package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExecutorConfiguration(
    lambdaExecutorConfiguration: Option[
      zio.aws.codepipeline.model.LambdaExecutorConfiguration
    ] = None,
    jobWorkerExecutorConfiguration: Option[
      zio.aws.codepipeline.model.JobWorkerExecutorConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ExecutorConfiguration = {
    import ExecutorConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ExecutorConfiguration
      .builder()
      .optionallyWith(
        lambdaExecutorConfiguration.map(value => value.buildAwsValue())
      )(_.lambdaExecutorConfiguration)
      .optionallyWith(
        jobWorkerExecutorConfiguration.map(value => value.buildAwsValue())
      )(_.jobWorkerExecutorConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ExecutorConfiguration.ReadOnly =
    zio.aws.codepipeline.model.ExecutorConfiguration.wrap(buildAwsValue())
}
object ExecutorConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ExecutorConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ExecutorConfiguration =
      zio.aws.codepipeline.model.ExecutorConfiguration(
        lambdaExecutorConfiguration.map(value => value.asEditable),
        jobWorkerExecutorConfiguration.map(value => value.asEditable)
      )
    def lambdaExecutorConfiguration: Option[
      zio.aws.codepipeline.model.LambdaExecutorConfiguration.ReadOnly
    ]
    def jobWorkerExecutorConfiguration: Option[
      zio.aws.codepipeline.model.JobWorkerExecutorConfiguration.ReadOnly
    ]
    def getLambdaExecutorConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.LambdaExecutorConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaExecutorConfiguration",
      lambdaExecutorConfiguration
    )
    def getJobWorkerExecutorConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.JobWorkerExecutorConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "jobWorkerExecutorConfiguration",
      jobWorkerExecutorConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ExecutorConfiguration
  ) extends zio.aws.codepipeline.model.ExecutorConfiguration.ReadOnly {
    override val lambdaExecutorConfiguration: Option[
      zio.aws.codepipeline.model.LambdaExecutorConfiguration.ReadOnly
    ] = scala
      .Option(impl.lambdaExecutorConfiguration())
      .map(value =>
        zio.aws.codepipeline.model.LambdaExecutorConfiguration.wrap(value)
      )
    override val jobWorkerExecutorConfiguration: Option[
      zio.aws.codepipeline.model.JobWorkerExecutorConfiguration.ReadOnly
    ] = scala
      .Option(impl.jobWorkerExecutorConfiguration())
      .map(value =>
        zio.aws.codepipeline.model.JobWorkerExecutorConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ExecutorConfiguration
  ): zio.aws.codepipeline.model.ExecutorConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
