package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  OutputVariablesValue,
  OutputVariablesKey,
  ContinuationToken,
  JobId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutJobSuccessResultRequest(
    jobId: JobId,
    currentRevision: Option[zio.aws.codepipeline.model.CurrentRevision] = None,
    continuationToken: Option[ContinuationToken] = None,
    executionDetails: Option[zio.aws.codepipeline.model.ExecutionDetails] =
      None,
    outputVariables: Option[Map[OutputVariablesKey, OutputVariablesValue]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest = {
    import PutJobSuccessResultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(currentRevision.map(value => value.buildAwsValue()))(
        _.currentRevision
      )
      .optionallyWith(
        continuationToken.map(value =>
          ContinuationToken.unwrap(value): java.lang.String
        )
      )(_.continuationToken)
      .optionallyWith(executionDetails.map(value => value.buildAwsValue()))(
        _.executionDetails
      )
      .optionallyWith(
        outputVariables.map(value =>
          value
            .map({ case (key, value) =>
              (OutputVariablesKey
                .unwrap(key): java.lang.String) -> (OutputVariablesValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.outputVariables)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.PutJobSuccessResultRequest.ReadOnly =
    zio.aws.codepipeline.model.PutJobSuccessResultRequest.wrap(buildAwsValue())
}
object PutJobSuccessResultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PutJobSuccessResultRequest =
      zio.aws.codepipeline.model.PutJobSuccessResultRequest(
        jobId,
        currentRevision.map(value => value.asEditable),
        continuationToken.map(value => value),
        executionDetails.map(value => value.asEditable),
        outputVariables.map(value => value)
      )
    def jobId: JobId
    def currentRevision
        : Option[zio.aws.codepipeline.model.CurrentRevision.ReadOnly]
    def continuationToken: Option[ContinuationToken]
    def executionDetails
        : Option[zio.aws.codepipeline.model.ExecutionDetails.ReadOnly]
    def outputVariables: Option[Map[OutputVariablesKey, OutputVariablesValue]]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getCurrentRevision: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.CurrentRevision.ReadOnly
    ] = AwsError.unwrapOptionField("currentRevision", currentRevision)
    def getContinuationToken: ZIO[Any, AwsError, ContinuationToken] =
      AwsError.unwrapOptionField("continuationToken", continuationToken)
    def getExecutionDetails: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ExecutionDetails.ReadOnly
    ] = AwsError.unwrapOptionField("executionDetails", executionDetails)
    def getOutputVariables
        : ZIO[Any, AwsError, Map[OutputVariablesKey, OutputVariablesValue]] =
      AwsError.unwrapOptionField("outputVariables", outputVariables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest
  ) extends zio.aws.codepipeline.model.PutJobSuccessResultRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.codepipeline.model.primitives.JobId(impl.jobId())
    override val currentRevision
        : Option[zio.aws.codepipeline.model.CurrentRevision.ReadOnly] = scala
      .Option(impl.currentRevision())
      .map(value => zio.aws.codepipeline.model.CurrentRevision.wrap(value))
    override val continuationToken: Option[ContinuationToken] = scala
      .Option(impl.continuationToken())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ContinuationToken(value)
      )
    override val executionDetails
        : Option[zio.aws.codepipeline.model.ExecutionDetails.ReadOnly] = scala
      .Option(impl.executionDetails())
      .map(value => zio.aws.codepipeline.model.ExecutionDetails.wrap(value))
    override val outputVariables
        : Option[Map[OutputVariablesKey, OutputVariablesValue]] = scala
      .Option(impl.outputVariables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codepipeline.model.primitives
              .OutputVariablesKey(key) -> zio.aws.codepipeline.model.primitives
              .OutputVariablesValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PutJobSuccessResultRequest
  ): zio.aws.codepipeline.model.PutJobSuccessResultRequest.ReadOnly =
    new Wrapper(impl)
}
