package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{UrlTemplate, Url}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ActionTypeUrls(
    configurationUrl: Option[Url] = None,
    entityUrlTemplate: Option[UrlTemplate] = None,
    executionUrlTemplate: Option[UrlTemplate] = None,
    revisionUrlTemplate: Option[UrlTemplate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionTypeUrls = {
    import ActionTypeUrls.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionTypeUrls
      .builder()
      .optionallyWith(
        configurationUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.configurationUrl)
      .optionallyWith(
        entityUrlTemplate.map(value =>
          UrlTemplate.unwrap(value): java.lang.String
        )
      )(_.entityUrlTemplate)
      .optionallyWith(
        executionUrlTemplate.map(value =>
          UrlTemplate.unwrap(value): java.lang.String
        )
      )(_.executionUrlTemplate)
      .optionallyWith(
        revisionUrlTemplate.map(value =>
          UrlTemplate.unwrap(value): java.lang.String
        )
      )(_.revisionUrlTemplate)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionTypeUrls.ReadOnly =
    zio.aws.codepipeline.model.ActionTypeUrls.wrap(buildAwsValue())
}
object ActionTypeUrls {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionTypeUrls
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionTypeUrls =
      zio.aws.codepipeline.model.ActionTypeUrls(
        configurationUrl.map(value => value),
        entityUrlTemplate.map(value => value),
        executionUrlTemplate.map(value => value),
        revisionUrlTemplate.map(value => value)
      )
    def configurationUrl: Option[Url]
    def entityUrlTemplate: Option[UrlTemplate]
    def executionUrlTemplate: Option[UrlTemplate]
    def revisionUrlTemplate: Option[UrlTemplate]
    def getConfigurationUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("configurationUrl", configurationUrl)
    def getEntityUrlTemplate: ZIO[Any, AwsError, UrlTemplate] =
      AwsError.unwrapOptionField("entityUrlTemplate", entityUrlTemplate)
    def getExecutionUrlTemplate: ZIO[Any, AwsError, UrlTemplate] =
      AwsError.unwrapOptionField("executionUrlTemplate", executionUrlTemplate)
    def getRevisionUrlTemplate: ZIO[Any, AwsError, UrlTemplate] =
      AwsError.unwrapOptionField("revisionUrlTemplate", revisionUrlTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeUrls
  ) extends zio.aws.codepipeline.model.ActionTypeUrls.ReadOnly {
    override val configurationUrl: Option[Url] = scala
      .Option(impl.configurationUrl())
      .map(value => zio.aws.codepipeline.model.primitives.Url(value))
    override val entityUrlTemplate: Option[UrlTemplate] = scala
      .Option(impl.entityUrlTemplate())
      .map(value => zio.aws.codepipeline.model.primitives.UrlTemplate(value))
    override val executionUrlTemplate: Option[UrlTemplate] = scala
      .Option(impl.executionUrlTemplate())
      .map(value => zio.aws.codepipeline.model.primitives.UrlTemplate(value))
    override val revisionUrlTemplate: Option[UrlTemplate] = scala
      .Option(impl.revisionUrlTemplate())
      .map(value => zio.aws.codepipeline.model.primitives.UrlTemplate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeUrls
  ): zio.aws.codepipeline.model.ActionTypeUrls.ReadOnly = new Wrapper(impl)
}
