package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  SessionToken,
  SecretAccessKey,
  AccessKeyId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AWSSessionCredentials(
    accessKeyId: AccessKeyId,
    secretAccessKey: SecretAccessKey,
    sessionToken: SessionToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.AWSSessionCredentials = {
    import AWSSessionCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.AWSSessionCredentials
      .builder()
      .accessKeyId(AccessKeyId.unwrap(accessKeyId): java.lang.String)
      .secretAccessKey(
        SecretAccessKey.unwrap(secretAccessKey): java.lang.String
      )
      .sessionToken(SessionToken.unwrap(sessionToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.AWSSessionCredentials.ReadOnly =
    zio.aws.codepipeline.model.AWSSessionCredentials.wrap(buildAwsValue())
}
object AWSSessionCredentials {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.AWSSessionCredentials
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.AWSSessionCredentials =
      zio.aws.codepipeline.model
        .AWSSessionCredentials(accessKeyId, secretAccessKey, sessionToken)
    def accessKeyId: AccessKeyId
    def secretAccessKey: SecretAccessKey
    def sessionToken: SessionToken
    def getAccessKeyId: ZIO[Any, Nothing, AccessKeyId] =
      ZIO.succeed(accessKeyId)
    def getSecretAccessKey: ZIO[Any, Nothing, SecretAccessKey] =
      ZIO.succeed(secretAccessKey)
    def getSessionToken: ZIO[Any, Nothing, SessionToken] =
      ZIO.succeed(sessionToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.AWSSessionCredentials
  ) extends zio.aws.codepipeline.model.AWSSessionCredentials.ReadOnly {
    override val accessKeyId: AccessKeyId =
      zio.aws.codepipeline.model.primitives.AccessKeyId(impl.accessKeyId())
    override val secretAccessKey: SecretAccessKey =
      zio.aws.codepipeline.model.primitives
        .SecretAccessKey(impl.secretAccessKey())
    override val sessionToken: SessionToken =
      zio.aws.codepipeline.model.primitives.SessionToken(impl.sessionToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.AWSSessionCredentials
  ): zio.aws.codepipeline.model.AWSSessionCredentials.ReadOnly = new Wrapper(
    impl
  )
}
