package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{AWSRegionName, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListActionTypesRequest(
    actionOwnerFilter: Option[zio.aws.codepipeline.model.ActionOwner] = None,
    nextToken: Option[NextToken] = None,
    regionFilter: Option[AWSRegionName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest = {
    import ListActionTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest
      .builder()
      .optionallyWith(actionOwnerFilter.map(value => value.unwrap))(
        _.actionOwnerFilter
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        regionFilter.map(value => AWSRegionName.unwrap(value): java.lang.String)
      )(_.regionFilter)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ListActionTypesRequest.ReadOnly =
    zio.aws.codepipeline.model.ListActionTypesRequest.wrap(buildAwsValue())
}
object ListActionTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListActionTypesRequest =
      zio.aws.codepipeline.model.ListActionTypesRequest(
        actionOwnerFilter.map(value => value),
        nextToken.map(value => value),
        regionFilter.map(value => value)
      )
    def actionOwnerFilter: Option[zio.aws.codepipeline.model.ActionOwner]
    def nextToken: Option[NextToken]
    def regionFilter: Option[AWSRegionName]
    def getActionOwnerFilter
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.ActionOwner] =
      AwsError.unwrapOptionField("actionOwnerFilter", actionOwnerFilter)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRegionFilter: ZIO[Any, AwsError, AWSRegionName] =
      AwsError.unwrapOptionField("regionFilter", regionFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest
  ) extends zio.aws.codepipeline.model.ListActionTypesRequest.ReadOnly {
    override val actionOwnerFilter
        : Option[zio.aws.codepipeline.model.ActionOwner] = scala
      .Option(impl.actionOwnerFilter())
      .map(value => zio.aws.codepipeline.model.ActionOwner.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codepipeline.model.primitives.NextToken(value))
    override val regionFilter: Option[AWSRegionName] = scala
      .Option(impl.regionFilter())
      .map(value => zio.aws.codepipeline.model.primitives.AWSRegionName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListActionTypesRequest
  ): zio.aws.codepipeline.model.ListActionTypesRequest.ReadOnly = new Wrapper(
    impl
  )
}
