package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetPipelineExecutionResponse(
    pipelineExecution: Option[zio.aws.codepipeline.model.PipelineExecution] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionResponse = {
    import GetPipelineExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionResponse
      .builder()
      .optionallyWith(pipelineExecution.map(value => value.buildAwsValue()))(
        _.pipelineExecution
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.GetPipelineExecutionResponse.ReadOnly =
    zio.aws.codepipeline.model.GetPipelineExecutionResponse
      .wrap(buildAwsValue())
}
object GetPipelineExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.GetPipelineExecutionResponse =
      zio.aws.codepipeline.model.GetPipelineExecutionResponse(
        pipelineExecution.map(value => value.asEditable)
      )
    def pipelineExecution
        : Option[zio.aws.codepipeline.model.PipelineExecution.ReadOnly]
    def getPipelineExecution: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineExecution.ReadOnly
    ] = AwsError.unwrapOptionField("pipelineExecution", pipelineExecution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionResponse
  ) extends zio.aws.codepipeline.model.GetPipelineExecutionResponse.ReadOnly {
    override val pipelineExecution
        : Option[zio.aws.codepipeline.model.PipelineExecution.ReadOnly] = scala
      .Option(impl.pipelineExecution())
      .map(value => zio.aws.codepipeline.model.PipelineExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.GetPipelineExecutionResponse
  ): zio.aws.codepipeline.model.GetPipelineExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
