package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  ActionConfigurationKey,
  ActionNamespace,
  RoleArn,
  ActionConfigurationValue,
  AWSRegionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ActionExecutionInput(
    actionTypeId: Option[zio.aws.codepipeline.model.ActionTypeId] = None,
    configuration: Option[
      Map[ActionConfigurationKey, ActionConfigurationValue]
    ] = None,
    resolvedConfiguration: Option[Map[String, String]] = None,
    roleArn: Option[RoleArn] = None,
    region: Option[AWSRegionName] = None,
    inputArtifacts: Option[
      Iterable[zio.aws.codepipeline.model.ArtifactDetail]
    ] = None,
    namespace: Option[ActionNamespace] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionExecutionInput = {
    import ActionExecutionInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionExecutionInput
      .builder()
      .optionallyWith(actionTypeId.map(value => value.buildAwsValue()))(
        _.actionTypeId
      )
      .optionallyWith(
        configuration.map(value =>
          value
            .map({ case (key, value) =>
              (ActionConfigurationKey.unwrap(
                key
              ): java.lang.String) -> (ActionConfigurationValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.configuration)
      .optionallyWith(
        resolvedConfiguration.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.resolvedConfiguration)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        region.map(value => AWSRegionName.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        inputArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputArtifacts)
      .optionallyWith(
        namespace.map(value => ActionNamespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionExecutionInput.ReadOnly =
    zio.aws.codepipeline.model.ActionExecutionInput.wrap(buildAwsValue())
}
object ActionExecutionInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionExecutionInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionExecutionInput =
      zio.aws.codepipeline.model.ActionExecutionInput(
        actionTypeId.map(value => value.asEditable),
        configuration.map(value => value),
        resolvedConfiguration.map(value => value),
        roleArn.map(value => value),
        region.map(value => value),
        inputArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        namespace.map(value => value)
      )
    def actionTypeId: Option[zio.aws.codepipeline.model.ActionTypeId.ReadOnly]
    def configuration
        : Option[Map[ActionConfigurationKey, ActionConfigurationValue]]
    def resolvedConfiguration: Option[Map[String, String]]
    def roleArn: Option[RoleArn]
    def region: Option[AWSRegionName]
    def inputArtifacts
        : Option[List[zio.aws.codepipeline.model.ArtifactDetail.ReadOnly]]
    def namespace: Option[ActionNamespace]
    def getActionTypeId
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.ActionTypeId.ReadOnly] =
      AwsError.unwrapOptionField("actionTypeId", actionTypeId)
    def getConfiguration: ZIO[Any, AwsError, Map[
      ActionConfigurationKey,
      ActionConfigurationValue
    ]] = AwsError.unwrapOptionField("configuration", configuration)
    def getResolvedConfiguration: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("resolvedConfiguration", resolvedConfiguration)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getRegion: ZIO[Any, AwsError, AWSRegionName] =
      AwsError.unwrapOptionField("region", region)
    def getInputArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.ArtifactDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("inputArtifacts", inputArtifacts)
    def getNamespace: ZIO[Any, AwsError, ActionNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionExecutionInput
  ) extends zio.aws.codepipeline.model.ActionExecutionInput.ReadOnly {
    override val actionTypeId
        : Option[zio.aws.codepipeline.model.ActionTypeId.ReadOnly] = scala
      .Option(impl.actionTypeId())
      .map(value => zio.aws.codepipeline.model.ActionTypeId.wrap(value))
    override val configuration
        : Option[Map[ActionConfigurationKey, ActionConfigurationValue]] = scala
      .Option(impl.configuration())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codepipeline.model.primitives.ActionConfigurationKey(
              key
            ) -> zio.aws.codepipeline.model.primitives
              .ActionConfigurationValue(value)
          })
          .toMap
      )
    override val resolvedConfiguration: Option[Map[String, String]] = scala
      .Option(impl.resolvedConfiguration())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.codepipeline.model.primitives.RoleArn(value))
    override val region: Option[AWSRegionName] = scala
      .Option(impl.region())
      .map(value => zio.aws.codepipeline.model.primitives.AWSRegionName(value))
    override val inputArtifacts
        : Option[List[zio.aws.codepipeline.model.ArtifactDetail.ReadOnly]] =
      scala
        .Option(impl.inputArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.ArtifactDetail.wrap(item)
          }.toList
        )
    override val namespace: Option[ActionNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ActionNamespace(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionExecutionInput
  ): zio.aws.codepipeline.model.ActionExecutionInput.ReadOnly = new Wrapper(
    impl
  )
}
