package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class PutApprovalResultResponse(
    approvedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PutApprovalResultResponse = {
    import PutApprovalResultResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PutApprovalResultResponse
      .builder()
      .optionallyWith(
        approvedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.approvedAt)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.PutApprovalResultResponse.ReadOnly =
    zio.aws.codepipeline.model.PutApprovalResultResponse.wrap(buildAwsValue())
}
object PutApprovalResultResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PutApprovalResultResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PutApprovalResultResponse =
      zio.aws.codepipeline.model
        .PutApprovalResultResponse(approvedAt.map(value => value))
    def approvedAt: Option[Timestamp]
    def getApprovedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("approvedAt", approvedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PutApprovalResultResponse
  ) extends zio.aws.codepipeline.model.PutApprovalResultResponse.ReadOnly {
    override val approvedAt: Option[Timestamp] = scala
      .Option(impl.approvedAt())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PutApprovalResultResponse
  ): zio.aws.codepipeline.model.PutApprovalResultResponse.ReadOnly =
    new Wrapper(impl)
}
