package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Version, ActionProvider}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCustomActionTypeRequest(
    category: zio.aws.codepipeline.model.ActionCategory,
    provider: ActionProvider,
    version: Version,
    settings: Option[zio.aws.codepipeline.model.ActionTypeSettings] = None,
    configurationProperties: Option[
      Iterable[zio.aws.codepipeline.model.ActionConfigurationProperty]
    ] = None,
    inputArtifactDetails: zio.aws.codepipeline.model.ArtifactDetails,
    outputArtifactDetails: zio.aws.codepipeline.model.ArtifactDetails,
    tags: Option[Iterable[zio.aws.codepipeline.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeRequest = {
    import CreateCustomActionTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeRequest
      .builder()
      .category(category.unwrap)
      .provider(ActionProvider.unwrap(provider): java.lang.String)
      .version(Version.unwrap(version): java.lang.String)
      .optionallyWith(settings.map(value => value.buildAwsValue()))(_.settings)
      .optionallyWith(
        configurationProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurationProperties)
      .inputArtifactDetails(inputArtifactDetails.buildAwsValue())
      .outputArtifactDetails(outputArtifactDetails.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.CreateCustomActionTypeRequest.ReadOnly =
    zio.aws.codepipeline.model.CreateCustomActionTypeRequest
      .wrap(buildAwsValue())
}
object CreateCustomActionTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.CreateCustomActionTypeRequest =
      zio.aws.codepipeline.model.CreateCustomActionTypeRequest(
        category,
        provider,
        version,
        settings.map(value => value.asEditable),
        configurationProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inputArtifactDetails.asEditable,
        outputArtifactDetails.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def category: zio.aws.codepipeline.model.ActionCategory
    def provider: ActionProvider
    def version: Version
    def settings: Option[zio.aws.codepipeline.model.ActionTypeSettings.ReadOnly]
    def configurationProperties: Option[
      List[zio.aws.codepipeline.model.ActionConfigurationProperty.ReadOnly]
    ]
    def inputArtifactDetails
        : zio.aws.codepipeline.model.ArtifactDetails.ReadOnly
    def outputArtifactDetails
        : zio.aws.codepipeline.model.ArtifactDetails.ReadOnly
    def tags: Option[List[zio.aws.codepipeline.model.Tag.ReadOnly]]
    def getCategory
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.ActionCategory] =
      ZIO.succeed(category)
    def getProvider: ZIO[Any, Nothing, ActionProvider] = ZIO.succeed(provider)
    def getVersion: ZIO[Any, Nothing, Version] = ZIO.succeed(version)
    def getSettings: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionTypeSettings.ReadOnly
    ] = AwsError.unwrapOptionField("settings", settings)
    def getConfigurationProperties: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.ActionConfigurationProperty.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "configurationProperties",
      configurationProperties
    )
    def getInputArtifactDetails: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.ArtifactDetails.ReadOnly
    ] = ZIO.succeed(inputArtifactDetails)
    def getOutputArtifactDetails: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.ArtifactDetails.ReadOnly
    ] = ZIO.succeed(outputArtifactDetails)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codepipeline.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeRequest
  ) extends zio.aws.codepipeline.model.CreateCustomActionTypeRequest.ReadOnly {
    override val category: zio.aws.codepipeline.model.ActionCategory =
      zio.aws.codepipeline.model.ActionCategory.wrap(impl.category())
    override val provider: ActionProvider =
      zio.aws.codepipeline.model.primitives.ActionProvider(impl.provider())
    override val version: Version =
      zio.aws.codepipeline.model.primitives.Version(impl.version())
    override val settings
        : Option[zio.aws.codepipeline.model.ActionTypeSettings.ReadOnly] = scala
      .Option(impl.settings())
      .map(value => zio.aws.codepipeline.model.ActionTypeSettings.wrap(value))
    override val configurationProperties: Option[
      List[zio.aws.codepipeline.model.ActionConfigurationProperty.ReadOnly]
    ] = scala
      .Option(impl.configurationProperties())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.ActionConfigurationProperty.wrap(item)
        }.toList
      )
    override val inputArtifactDetails
        : zio.aws.codepipeline.model.ArtifactDetails.ReadOnly =
      zio.aws.codepipeline.model.ArtifactDetails
        .wrap(impl.inputArtifactDetails())
    override val outputArtifactDetails
        : zio.aws.codepipeline.model.ArtifactDetails.ReadOnly =
      zio.aws.codepipeline.model.ArtifactDetails
        .wrap(impl.outputArtifactDetails())
    override val tags: Option[List[zio.aws.codepipeline.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeRequest
  ): zio.aws.codepipeline.model.CreateCustomActionTypeRequest.ReadOnly =
    new Wrapper(impl)
}
