package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.PipelineExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartPipelineExecutionResponse(
    pipelineExecutionId: Option[PipelineExecutionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionResponse = {
    import StartPipelineExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionResponse
      .builder()
      .optionallyWith(
        pipelineExecutionId.map(value =>
          PipelineExecutionId.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionId)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.StartPipelineExecutionResponse.ReadOnly =
    zio.aws.codepipeline.model.StartPipelineExecutionResponse
      .wrap(buildAwsValue())
}
object StartPipelineExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StartPipelineExecutionResponse =
      zio.aws.codepipeline.model
        .StartPipelineExecutionResponse(pipelineExecutionId.map(value => value))
    def pipelineExecutionId: Option[PipelineExecutionId]
    def getPipelineExecutionId: ZIO[Any, AwsError, PipelineExecutionId] =
      AwsError.unwrapOptionField("pipelineExecutionId", pipelineExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionResponse
  ) extends zio.aws.codepipeline.model.StartPipelineExecutionResponse.ReadOnly {
    override val pipelineExecutionId: Option[PipelineExecutionId] = scala
      .Option(impl.pipelineExecutionId())
      .map(value =>
        zio.aws.codepipeline.model.primitives.PipelineExecutionId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionResponse
  ): zio.aws.codepipeline.model.StartPipelineExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
