package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Timestamp, PipelineExecutionId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class PipelineExecutionSummary(
    pipelineExecutionId: Option[PipelineExecutionId] = None,
    status: Option[zio.aws.codepipeline.model.PipelineExecutionStatus] = None,
    startTime: Option[Timestamp] = None,
    lastUpdateTime: Option[Timestamp] = None,
    sourceRevisions: Option[
      Iterable[zio.aws.codepipeline.model.SourceRevision]
    ] = None,
    trigger: Option[zio.aws.codepipeline.model.ExecutionTrigger] = None,
    stopTrigger: Option[zio.aws.codepipeline.model.StopExecutionTrigger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummary = {
    import PipelineExecutionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummary
      .builder()
      .optionallyWith(
        pipelineExecutionId.map(value =>
          PipelineExecutionId.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(
        sourceRevisions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceRevisions)
      .optionallyWith(trigger.map(value => value.buildAwsValue()))(_.trigger)
      .optionallyWith(stopTrigger.map(value => value.buildAwsValue()))(
        _.stopTrigger
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PipelineExecutionSummary.ReadOnly =
    zio.aws.codepipeline.model.PipelineExecutionSummary.wrap(buildAwsValue())
}
object PipelineExecutionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineExecutionSummary =
      zio.aws.codepipeline.model.PipelineExecutionSummary(
        pipelineExecutionId.map(value => value),
        status.map(value => value),
        startTime.map(value => value),
        lastUpdateTime.map(value => value),
        sourceRevisions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        trigger.map(value => value.asEditable),
        stopTrigger.map(value => value.asEditable)
      )
    def pipelineExecutionId: Option[PipelineExecutionId]
    def status: Option[zio.aws.codepipeline.model.PipelineExecutionStatus]
    def startTime: Option[Timestamp]
    def lastUpdateTime: Option[Timestamp]
    def sourceRevisions
        : Option[List[zio.aws.codepipeline.model.SourceRevision.ReadOnly]]
    def trigger: Option[zio.aws.codepipeline.model.ExecutionTrigger.ReadOnly]
    def stopTrigger
        : Option[zio.aws.codepipeline.model.StopExecutionTrigger.ReadOnly]
    def getPipelineExecutionId: ZIO[Any, AwsError, PipelineExecutionId] =
      AwsError.unwrapOptionField("pipelineExecutionId", pipelineExecutionId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getSourceRevisions: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.SourceRevision.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceRevisions", sourceRevisions)
    def getTrigger: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ExecutionTrigger.ReadOnly
    ] = AwsError.unwrapOptionField("trigger", trigger)
    def getStopTrigger: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.StopExecutionTrigger.ReadOnly
    ] = AwsError.unwrapOptionField("stopTrigger", stopTrigger)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummary
  ) extends zio.aws.codepipeline.model.PipelineExecutionSummary.ReadOnly {
    override val pipelineExecutionId: Option[PipelineExecutionId] = scala
      .Option(impl.pipelineExecutionId())
      .map(value =>
        zio.aws.codepipeline.model.primitives.PipelineExecutionId(value)
      )
    override val status
        : Option[zio.aws.codepipeline.model.PipelineExecutionStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.codepipeline.model.PipelineExecutionStatus.wrap(value)
      )
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val lastUpdateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdateTime())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val sourceRevisions
        : Option[List[zio.aws.codepipeline.model.SourceRevision.ReadOnly]] =
      scala
        .Option(impl.sourceRevisions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.SourceRevision.wrap(item)
          }.toList
        )
    override val trigger
        : Option[zio.aws.codepipeline.model.ExecutionTrigger.ReadOnly] = scala
      .Option(impl.trigger())
      .map(value => zio.aws.codepipeline.model.ExecutionTrigger.wrap(value))
    override val stopTrigger
        : Option[zio.aws.codepipeline.model.StopExecutionTrigger.ReadOnly] =
      scala
        .Option(impl.stopTrigger())
        .map(value =>
          zio.aws.codepipeline.model.StopExecutionTrigger.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineExecutionSummary
  ): zio.aws.codepipeline.model.PipelineExecutionSummary.ReadOnly = new Wrapper(
    impl
  )
}
