package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ResourceArn,
    tags: Iterable[zio.aws.codepipeline.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.TagResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.TagResourceRequest.ReadOnly =
    zio.aws.codepipeline.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.TagResourceRequest =
      zio.aws.codepipeline.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: ResourceArn
    def tags: List[zio.aws.codepipeline.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.codepipeline.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.TagResourceRequest
  ) extends zio.aws.codepipeline.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.codepipeline.model.primitives.ResourceArn(impl.resourceArn())
    override val tags: List[zio.aws.codepipeline.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.codepipeline.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.TagResourceRequest
  ): zio.aws.codepipeline.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
