package zio.aws.codepipeline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  Timestamp,
  PipelineVersion,
  PipelineName
}
import scala.jdk.CollectionConverters._
final case class PipelineSummary(
    name: Optional[PipelineName] = Optional.Absent,
    version: Optional[PipelineVersion] = Optional.Absent,
    pipelineType: Optional[zio.aws.codepipeline.model.PipelineType] =
      Optional.Absent,
    created: Optional[Timestamp] = Optional.Absent,
    updated: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineSummary = {
    import PipelineSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineSummary
      .builder()
      .optionallyWith(
        name.map(value => PipelineName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        version.map(value => PipelineVersion.unwrap(value): Integer)
      )(_.version)
      .optionallyWith(pipelineType.map(value => value.unwrap))(_.pipelineType)
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(updated.map(value => Timestamp.unwrap(value): Instant))(
        _.updated
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PipelineSummary.ReadOnly =
    zio.aws.codepipeline.model.PipelineSummary.wrap(buildAwsValue())
}
object PipelineSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineSummary =
      zio.aws.codepipeline.model.PipelineSummary(
        name.map(value => value),
        version.map(value => value),
        pipelineType.map(value => value),
        created.map(value => value),
        updated.map(value => value)
      )
    def name: Optional[PipelineName]
    def version: Optional[PipelineVersion]
    def pipelineType: Optional[zio.aws.codepipeline.model.PipelineType]
    def created: Optional[Timestamp]
    def updated: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, PipelineVersion] =
      AwsError.unwrapOptionField("version", version)
    def getPipelineType
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.PipelineType] =
      AwsError.unwrapOptionField("pipelineType", pipelineType)
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updated", updated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineSummary
  ) extends zio.aws.codepipeline.model.PipelineSummary.ReadOnly {
    override val name: Optional[PipelineName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codepipeline.model.primitives.PipelineName(value))
    override val version: Optional[PipelineVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value =>
        zio.aws.codepipeline.model.primitives.PipelineVersion(value)
      )
    override val pipelineType
        : Optional[zio.aws.codepipeline.model.PipelineType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineType())
        .map(value => zio.aws.codepipeline.model.PipelineType.wrap(value))
    override val created: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val updated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updated())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineSummary
  ): zio.aws.codepipeline.model.PipelineSummary.ReadOnly = new Wrapper(impl)
}
