package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.PipelineName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeletePipelineRequest(name: PipelineName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.DeletePipelineRequest = {
    import DeletePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.DeletePipelineRequest
      .builder()
      .name(PipelineName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.DeletePipelineRequest.ReadOnly =
    zio.aws.codepipeline.model.DeletePipelineRequest.wrap(buildAwsValue())
}
object DeletePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.DeletePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.DeletePipelineRequest =
      zio.aws.codepipeline.model.DeletePipelineRequest(name)
    def name: PipelineName
    def getName: ZIO[Any, Nothing, PipelineName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.DeletePipelineRequest
  ) extends zio.aws.codepipeline.model.DeletePipelineRequest.ReadOnly {
    override val name: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.DeletePipelineRequest
  ): zio.aws.codepipeline.model.DeletePipelineRequest.ReadOnly = new Wrapper(
    impl
  )
}
