package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  PipelineVariableValue,
  PipelineVariableName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PipelineVariable(
    name: PipelineVariableName,
    value: PipelineVariableValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineVariable = {
    import PipelineVariable.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineVariable
      .builder()
      .name(PipelineVariableName.unwrap(name): java.lang.String)
      .value(PipelineVariableValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PipelineVariable.ReadOnly =
    zio.aws.codepipeline.model.PipelineVariable.wrap(buildAwsValue())
}
object PipelineVariable {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineVariable
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineVariable =
      zio.aws.codepipeline.model.PipelineVariable(name, value)
    def name: PipelineVariableName
    def value: PipelineVariableValue
    def getName: ZIO[Any, Nothing, PipelineVariableName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, PipelineVariableValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineVariable
  ) extends zio.aws.codepipeline.model.PipelineVariable.ReadOnly {
    override val name: PipelineVariableName =
      zio.aws.codepipeline.model.primitives.PipelineVariableName(impl.name())
    override val value: PipelineVariableValue =
      zio.aws.codepipeline.model.primitives.PipelineVariableValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineVariable
  ): zio.aws.codepipeline.model.PipelineVariable.ReadOnly = new Wrapper(impl)
}
