package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutWebhookRequest(
    webhook: zio.aws.codepipeline.model.WebhookDefinition,
    tags: Optional[Iterable[zio.aws.codepipeline.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PutWebhookRequest = {
    import PutWebhookRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PutWebhookRequest
      .builder()
      .webhook(webhook.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PutWebhookRequest.ReadOnly =
    zio.aws.codepipeline.model.PutWebhookRequest.wrap(buildAwsValue())
}
object PutWebhookRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PutWebhookRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PutWebhookRequest =
      zio.aws.codepipeline.model.PutWebhookRequest(
        webhook.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def webhook: zio.aws.codepipeline.model.WebhookDefinition.ReadOnly
    def tags: Optional[List[zio.aws.codepipeline.model.Tag.ReadOnly]]
    def getWebhook: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.WebhookDefinition.ReadOnly
    ] = ZIO.succeed(webhook)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codepipeline.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PutWebhookRequest
  ) extends zio.aws.codepipeline.model.PutWebhookRequest.ReadOnly {
    override val webhook
        : zio.aws.codepipeline.model.WebhookDefinition.ReadOnly =
      zio.aws.codepipeline.model.WebhookDefinition.wrap(impl.webhook())
    override val tags: Optional[List[zio.aws.codepipeline.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PutWebhookRequest
  ): zio.aws.codepipeline.model.PutWebhookRequest.ReadOnly = new Wrapper(impl)
}
