package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  PipelineExecutionId,
  StageName,
  PipelineName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RetryStageExecutionRequest(
    pipelineName: PipelineName,
    stageName: StageName,
    pipelineExecutionId: PipelineExecutionId,
    retryMode: zio.aws.codepipeline.model.StageRetryMode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionRequest = {
    import RetryStageExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .stageName(StageName.unwrap(stageName): java.lang.String)
      .pipelineExecutionId(
        PipelineExecutionId.unwrap(pipelineExecutionId): java.lang.String
      )
      .retryMode(retryMode.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.RetryStageExecutionRequest.ReadOnly =
    zio.aws.codepipeline.model.RetryStageExecutionRequest.wrap(buildAwsValue())
}
object RetryStageExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.RetryStageExecutionRequest =
      zio.aws.codepipeline.model.RetryStageExecutionRequest(
        pipelineName,
        stageName,
        pipelineExecutionId,
        retryMode
      )
    def pipelineName: PipelineName
    def stageName: StageName
    def pipelineExecutionId: PipelineExecutionId
    def retryMode: zio.aws.codepipeline.model.StageRetryMode
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getStageName: ZIO[Any, Nothing, StageName] = ZIO.succeed(stageName)
    def getPipelineExecutionId: ZIO[Any, Nothing, PipelineExecutionId] =
      ZIO.succeed(pipelineExecutionId)
    def getRetryMode
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.StageRetryMode] =
      ZIO.succeed(retryMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionRequest
  ) extends zio.aws.codepipeline.model.RetryStageExecutionRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.pipelineName())
    override val stageName: StageName =
      zio.aws.codepipeline.model.primitives.StageName(impl.stageName())
    override val pipelineExecutionId: PipelineExecutionId =
      zio.aws.codepipeline.model.primitives
        .PipelineExecutionId(impl.pipelineExecutionId())
    override val retryMode: zio.aws.codepipeline.model.StageRetryMode =
      zio.aws.codepipeline.model.StageRetryMode.wrap(impl.retryMode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.RetryStageExecutionRequest
  ): zio.aws.codepipeline.model.RetryStageExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
