package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.BlockerName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BlockerDeclaration(
    name: BlockerName,
    `type`: zio.aws.codepipeline.model.BlockerType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.BlockerDeclaration = {
    import BlockerDeclaration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.BlockerDeclaration
      .builder()
      .name(BlockerName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.BlockerDeclaration.ReadOnly =
    zio.aws.codepipeline.model.BlockerDeclaration.wrap(buildAwsValue())
}
object BlockerDeclaration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.BlockerDeclaration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.BlockerDeclaration =
      zio.aws.codepipeline.model.BlockerDeclaration(name, `type`)
    def name: BlockerName
    def `type`: zio.aws.codepipeline.model.BlockerType
    def getName: ZIO[Any, Nothing, BlockerName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.codepipeline.model.BlockerType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.BlockerDeclaration
  ) extends zio.aws.codepipeline.model.BlockerDeclaration.ReadOnly {
    override val name: BlockerName =
      zio.aws.codepipeline.model.primitives.BlockerName(impl.name())
    override val `type`: zio.aws.codepipeline.model.BlockerType =
      zio.aws.codepipeline.model.BlockerType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.BlockerDeclaration
  ): zio.aws.codepipeline.model.BlockerDeclaration.ReadOnly = new Wrapper(impl)
}
