package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters._
sealed trait EncryptionKeyType {
  def unwrap
      : software.amazon.awssdk.services.codepipeline.model.EncryptionKeyType
}
object EncryptionKeyType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.EncryptionKeyType
  ): zio.aws.codepipeline.model.EncryptionKeyType = value match {
    case software.amazon.awssdk.services.codepipeline.model.EncryptionKeyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.EncryptionKeyType.KMS =>
      val r = KMS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.EncryptionKeyType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.EncryptionKeyType =
      software.amazon.awssdk.services.codepipeline.model.EncryptionKeyType.UNKNOWN_TO_SDK_VERSION
  }
  case object KMS extends zio.aws.codepipeline.model.EncryptionKeyType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.EncryptionKeyType =
      software.amazon.awssdk.services.codepipeline.model.EncryptionKeyType.KMS
  }
}
