package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  Description,
  ActionConfigurationKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ActionConfigurationProperty(
    name: ActionConfigurationKey,
    required: Boolean,
    key: Boolean,
    secret: Boolean,
    queryable: Optional[Boolean] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    `type`: Optional[
      zio.aws.codepipeline.model.ActionConfigurationPropertyType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty = {
    import ActionConfigurationProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty
      .builder()
      .name(ActionConfigurationKey.unwrap(name): java.lang.String)
      .required(required: java.lang.Boolean)
      .key(key: java.lang.Boolean)
      .secret(secret: java.lang.Boolean)
      .optionallyWith(queryable.map(value => value: java.lang.Boolean))(
        _.queryable
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.ActionConfigurationProperty.ReadOnly =
    zio.aws.codepipeline.model.ActionConfigurationProperty.wrap(buildAwsValue())
}
object ActionConfigurationProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionConfigurationProperty =
      zio.aws.codepipeline.model.ActionConfigurationProperty(
        name,
        required,
        key,
        secret,
        queryable.map(value => value),
        description.map(value => value),
        `type`.map(value => value)
      )
    def name: ActionConfigurationKey
    def required: Boolean
    def key: Boolean
    def secret: Boolean
    def queryable: Optional[Boolean]
    def description: Optional[Description]
    def `type`
        : Optional[zio.aws.codepipeline.model.ActionConfigurationPropertyType]
    def getName: ZIO[Any, Nothing, ActionConfigurationKey] = ZIO.succeed(name)
    def getRequired: ZIO[Any, Nothing, Boolean] = ZIO.succeed(required)
    def getKey: ZIO[Any, Nothing, Boolean] = ZIO.succeed(key)
    def getSecret: ZIO[Any, Nothing, Boolean] = ZIO.succeed(secret)
    def getQueryable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("queryable", queryable)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionConfigurationPropertyType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty
  ) extends zio.aws.codepipeline.model.ActionConfigurationProperty.ReadOnly {
    override val name: ActionConfigurationKey =
      zio.aws.codepipeline.model.primitives.ActionConfigurationKey(impl.name())
    override val required: Boolean = impl.required(): Boolean
    override val key: Boolean = impl.key(): Boolean
    override val secret: Boolean = impl.secret(): Boolean
    override val queryable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.queryable())
      .map(value => value: Boolean)
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.codepipeline.model.primitives.Description(value))
    override val `type`
        : Optional[zio.aws.codepipeline.model.ActionConfigurationPropertyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.codepipeline.model.ActionConfigurationPropertyType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionConfigurationProperty
  ): zio.aws.codepipeline.model.ActionConfigurationProperty.ReadOnly =
    new Wrapper(impl)
}
