package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Message, Code}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ErrorDetails(
    code: Optional[Code] = Optional.Absent,
    message: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ErrorDetails = {
    import ErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ErrorDetails
      .builder()
      .optionallyWith(code.map(value => Code.unwrap(value): java.lang.String))(
        _.code
      )
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ErrorDetails.ReadOnly =
    zio.aws.codepipeline.model.ErrorDetails.wrap(buildAwsValue())
}
object ErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ErrorDetails =
      zio.aws.codepipeline.model
        .ErrorDetails(code.map(value => value), message.map(value => value))
    def code: Optional[Code]
    def message: Optional[Message]
    def getCode: ZIO[Any, AwsError, Code] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ErrorDetails
  ) extends zio.aws.codepipeline.model.ErrorDetails.ReadOnly {
    override val code: Optional[Code] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => zio.aws.codepipeline.model.primitives.Code(value))
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.codepipeline.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ErrorDetails
  ): zio.aws.codepipeline.model.ErrorDetails.ReadOnly = new Wrapper(impl)
}
