package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateActionTypeRequest(
    actionType: zio.aws.codepipeline.model.ActionTypeDeclaration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.UpdateActionTypeRequest = {
    import UpdateActionTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.UpdateActionTypeRequest
      .builder()
      .actionType(actionType.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.UpdateActionTypeRequest.ReadOnly =
    zio.aws.codepipeline.model.UpdateActionTypeRequest.wrap(buildAwsValue())
}
object UpdateActionTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.UpdateActionTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.UpdateActionTypeRequest =
      zio.aws.codepipeline.model.UpdateActionTypeRequest(actionType.asEditable)
    def actionType: zio.aws.codepipeline.model.ActionTypeDeclaration.ReadOnly
    def getActionType: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.ActionTypeDeclaration.ReadOnly
    ] = ZIO.succeed(actionType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.UpdateActionTypeRequest
  ) extends zio.aws.codepipeline.model.UpdateActionTypeRequest.ReadOnly {
    override val actionType
        : zio.aws.codepipeline.model.ActionTypeDeclaration.ReadOnly =
      zio.aws.codepipeline.model.ActionTypeDeclaration.wrap(impl.actionType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.UpdateActionTypeRequest
  ): zio.aws.codepipeline.model.UpdateActionTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
