package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters._
sealed trait ActionOwner {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.ActionOwner
}
object ActionOwner {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.ActionOwner
  ): zio.aws.codepipeline.model.ActionOwner = value match {
    case software.amazon.awssdk.services.codepipeline.model.ActionOwner.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionOwner.AWS =>
      val r = AWS
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionOwner.THIRD_PARTY =>
      val r = ThirdParty
      r
    case software.amazon.awssdk.services.codepipeline.model.ActionOwner.CUSTOM =>
      val r = Custom
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.ActionOwner {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionOwner =
      software.amazon.awssdk.services.codepipeline.model.ActionOwner.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS extends zio.aws.codepipeline.model.ActionOwner {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionOwner =
      software.amazon.awssdk.services.codepipeline.model.ActionOwner.AWS
  }
  case object ThirdParty extends zio.aws.codepipeline.model.ActionOwner {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionOwner =
      software.amazon.awssdk.services.codepipeline.model.ActionOwner.THIRD_PARTY
  }
  case object Custom extends zio.aws.codepipeline.model.ActionOwner {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ActionOwner =
      software.amazon.awssdk.services.codepipeline.model.ActionOwner.CUSTOM
  }
}
