package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.ApprovalSummary
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ApprovalResult(
    summary: ApprovalSummary,
    status: zio.aws.codepipeline.model.ApprovalStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ApprovalResult = {
    import ApprovalResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ApprovalResult
      .builder()
      .summary(ApprovalSummary.unwrap(summary): java.lang.String)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ApprovalResult.ReadOnly =
    zio.aws.codepipeline.model.ApprovalResult.wrap(buildAwsValue())
}
object ApprovalResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ApprovalResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ApprovalResult =
      zio.aws.codepipeline.model.ApprovalResult(summary, status)
    def summary: ApprovalSummary
    def status: zio.aws.codepipeline.model.ApprovalStatus
    def getSummary: ZIO[Any, Nothing, ApprovalSummary] = ZIO.succeed(summary)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.ApprovalStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ApprovalResult
  ) extends zio.aws.codepipeline.model.ApprovalResult.ReadOnly {
    override val summary: ApprovalSummary =
      zio.aws.codepipeline.model.primitives.ApprovalSummary(impl.summary())
    override val status: zio.aws.codepipeline.model.ApprovalStatus =
      zio.aws.codepipeline.model.ApprovalStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ApprovalResult
  ): zio.aws.codepipeline.model.ApprovalResult.ReadOnly = new Wrapper(impl)
}
