package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{ClientToken, ThirdPartyJobId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutThirdPartyJobFailureResultRequest(
    jobId: ThirdPartyJobId,
    clientToken: ClientToken,
    failureDetails: zio.aws.codepipeline.model.FailureDetails
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultRequest = {
    import PutThirdPartyJobFailureResultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultRequest
      .builder()
      .jobId(ThirdPartyJobId.unwrap(jobId): java.lang.String)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .failureDetails(failureDetails.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.PutThirdPartyJobFailureResultRequest.ReadOnly =
    zio.aws.codepipeline.model.PutThirdPartyJobFailureResultRequest
      .wrap(buildAwsValue())
}
object PutThirdPartyJobFailureResultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codepipeline.model.PutThirdPartyJobFailureResultRequest =
      zio.aws.codepipeline.model.PutThirdPartyJobFailureResultRequest(
        jobId,
        clientToken,
        failureDetails.asEditable
      )
    def jobId: ThirdPartyJobId
    def clientToken: ClientToken
    def failureDetails: zio.aws.codepipeline.model.FailureDetails.ReadOnly
    def getJobId: ZIO[Any, Nothing, ThirdPartyJobId] = ZIO.succeed(jobId)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getFailureDetails: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.FailureDetails.ReadOnly
    ] = ZIO.succeed(failureDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultRequest
  ) extends zio.aws.codepipeline.model.PutThirdPartyJobFailureResultRequest.ReadOnly {
    override val jobId: ThirdPartyJobId =
      zio.aws.codepipeline.model.primitives.ThirdPartyJobId(impl.jobId())
    override val clientToken: ClientToken =
      zio.aws.codepipeline.model.primitives.ClientToken(impl.clientToken())
    override val failureDetails
        : zio.aws.codepipeline.model.FailureDetails.ReadOnly =
      zio.aws.codepipeline.model.FailureDetails.wrap(impl.failureDetails())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobFailureResultRequest
  ): zio.aws.codepipeline.model.PutThirdPartyJobFailureResultRequest.ReadOnly =
    new Wrapper(impl)
}
