package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePipelineResponse(
    pipeline: Optional[zio.aws.codepipeline.model.PipelineDeclaration] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.codepipeline.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.CreatePipelineResponse = {
    import CreatePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.CreatePipelineResponse
      .builder()
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.CreatePipelineResponse.ReadOnly =
    zio.aws.codepipeline.model.CreatePipelineResponse.wrap(buildAwsValue())
}
object CreatePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.CreatePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.CreatePipelineResponse =
      zio.aws.codepipeline.model.CreatePipelineResponse(
        pipeline.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipeline
        : Optional[zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly]
    def tags: Optional[List[zio.aws.codepipeline.model.Tag.ReadOnly]]
    def getPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly
    ] = AwsError.unwrapOptionField("pipeline", pipeline)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codepipeline.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.CreatePipelineResponse
  ) extends zio.aws.codepipeline.model.CreatePipelineResponse.ReadOnly {
    override val pipeline
        : Optional[zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipeline())
        .map(value =>
          zio.aws.codepipeline.model.PipelineDeclaration.wrap(value)
        )
    override val tags: Optional[List[zio.aws.codepipeline.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.CreatePipelineResponse
  ): zio.aws.codepipeline.model.CreatePipelineResponse.ReadOnly = new Wrapper(
    impl
  )
}
