package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  Version,
  ActionProvider,
  ActionTypeOwner
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ActionTypeIdentifier(
    category: zio.aws.codepipeline.model.ActionCategory,
    owner: ActionTypeOwner,
    provider: ActionProvider,
    version: Version
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionTypeIdentifier = {
    import ActionTypeIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionTypeIdentifier
      .builder()
      .category(category.unwrap)
      .owner(ActionTypeOwner.unwrap(owner): java.lang.String)
      .provider(ActionProvider.unwrap(provider): java.lang.String)
      .version(Version.unwrap(version): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionTypeIdentifier.ReadOnly =
    zio.aws.codepipeline.model.ActionTypeIdentifier.wrap(buildAwsValue())
}
object ActionTypeIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionTypeIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionTypeIdentifier =
      zio.aws.codepipeline.model.ActionTypeIdentifier(
        category,
        owner,
        provider,
        version
      )
    def category: zio.aws.codepipeline.model.ActionCategory
    def owner: ActionTypeOwner
    def provider: ActionProvider
    def version: Version
    def getCategory
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.ActionCategory] =
      ZIO.succeed(category)
    def getOwner: ZIO[Any, Nothing, ActionTypeOwner] = ZIO.succeed(owner)
    def getProvider: ZIO[Any, Nothing, ActionProvider] = ZIO.succeed(provider)
    def getVersion: ZIO[Any, Nothing, Version] = ZIO.succeed(version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeIdentifier
  ) extends zio.aws.codepipeline.model.ActionTypeIdentifier.ReadOnly {
    override val category: zio.aws.codepipeline.model.ActionCategory =
      zio.aws.codepipeline.model.ActionCategory.wrap(impl.category())
    override val owner: ActionTypeOwner =
      zio.aws.codepipeline.model.primitives.ActionTypeOwner(impl.owner())
    override val provider: ActionProvider =
      zio.aws.codepipeline.model.primitives.ActionProvider(impl.provider())
    override val version: Version =
      zio.aws.codepipeline.model.primitives.Version(impl.version())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeIdentifier
  ): zio.aws.codepipeline.model.ActionTypeIdentifier.ReadOnly = new Wrapper(
    impl
  )
}
