package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{JobId, ClientId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ThirdPartyJob(
    clientId: Option[ClientId] = None,
    jobId: Option[JobId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ThirdPartyJob = {
    import ThirdPartyJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ThirdPartyJob
      .builder()
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ThirdPartyJob.ReadOnly =
    zio.aws.codepipeline.model.ThirdPartyJob.wrap(buildAwsValue())
}
object ThirdPartyJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ThirdPartyJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ThirdPartyJob =
      zio.aws.codepipeline.model
        .ThirdPartyJob(clientId.map(value => value), jobId.map(value => value))
    def clientId: Option[ClientId]
    def jobId: Option[JobId]
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ThirdPartyJob
  ) extends zio.aws.codepipeline.model.ThirdPartyJob.ReadOnly {
    override val clientId: Option[ClientId] = scala
      .Option(impl.clientId())
      .map(value => zio.aws.codepipeline.model.primitives.ClientId(value))
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.codepipeline.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ThirdPartyJob
  ): zio.aws.codepipeline.model.ThirdPartyJob.ReadOnly = new Wrapper(impl)
}
