package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters._
sealed trait ApprovalStatus {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.ApprovalStatus
}
object ApprovalStatus {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.ApprovalStatus
  ): zio.aws.codepipeline.model.ApprovalStatus = value match {
    case software.amazon.awssdk.services.codepipeline.model.ApprovalStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.ApprovalStatus.APPROVED =>
      val r = Approved
      r
    case software.amazon.awssdk.services.codepipeline.model.ApprovalStatus.REJECTED =>
      val r = Rejected
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.ApprovalStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ApprovalStatus =
      software.amazon.awssdk.services.codepipeline.model.ApprovalStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Approved extends zio.aws.codepipeline.model.ApprovalStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ApprovalStatus =
      software.amazon.awssdk.services.codepipeline.model.ApprovalStatus.APPROVED
  }
  case object Rejected extends zio.aws.codepipeline.model.ApprovalStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ApprovalStatus =
      software.amazon.awssdk.services.codepipeline.model.ApprovalStatus.REJECTED
  }
}
