package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateCustomActionTypeResponse(
    actionType: zio.aws.codepipeline.model.ActionType,
    tags: Option[Iterable[zio.aws.codepipeline.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeResponse = {
    import CreateCustomActionTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeResponse
      .builder()
      .actionType(actionType.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.CreateCustomActionTypeResponse.ReadOnly =
    zio.aws.codepipeline.model.CreateCustomActionTypeResponse
      .wrap(buildAwsValue())
}
object CreateCustomActionTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.CreateCustomActionTypeResponse =
      zio.aws.codepipeline.model.CreateCustomActionTypeResponse(
        actionType.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def actionType: zio.aws.codepipeline.model.ActionType.ReadOnly
    def tags: Option[List[zio.aws.codepipeline.model.Tag.ReadOnly]]
    def getActionType
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.ActionType.ReadOnly] =
      ZIO.succeed(actionType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.codepipeline.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeResponse
  ) extends zio.aws.codepipeline.model.CreateCustomActionTypeResponse.ReadOnly {
    override val actionType: zio.aws.codepipeline.model.ActionType.ReadOnly =
      zio.aws.codepipeline.model.ActionType.wrap(impl.actionType())
    override val tags: Option[List[zio.aws.codepipeline.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.CreateCustomActionTypeResponse
  ): zio.aws.codepipeline.model.CreateCustomActionTypeResponse.ReadOnly =
    new Wrapper(impl)
}
