package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdatePipelineResponse(
    pipeline: Option[zio.aws.codepipeline.model.PipelineDeclaration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.UpdatePipelineResponse = {
    import UpdatePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.UpdatePipelineResponse
      .builder()
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.UpdatePipelineResponse.ReadOnly =
    zio.aws.codepipeline.model.UpdatePipelineResponse.wrap(buildAwsValue())
}
object UpdatePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.UpdatePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.UpdatePipelineResponse =
      zio.aws.codepipeline.model
        .UpdatePipelineResponse(pipeline.map(value => value.asEditable))
    def pipeline
        : Option[zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly]
    def getPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly
    ] = AwsError.unwrapOptionField("pipeline", pipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.UpdatePipelineResponse
  ) extends zio.aws.codepipeline.model.UpdatePipelineResponse.ReadOnly {
    override val pipeline
        : Option[zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly] =
      scala
        .Option(impl.pipeline())
        .map(value =>
          zio.aws.codepipeline.model.PipelineDeclaration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.UpdatePipelineResponse
  ): zio.aws.codepipeline.model.UpdatePipelineResponse.ReadOnly = new Wrapper(
    impl
  )
}
