package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{S3ObjectKey, S3BucketName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3ArtifactLocation(
    bucketName: S3BucketName,
    objectKey: S3ObjectKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.S3ArtifactLocation = {
    import S3ArtifactLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.S3ArtifactLocation
      .builder()
      .bucketName(S3BucketName.unwrap(bucketName): java.lang.String)
      .objectKey(S3ObjectKey.unwrap(objectKey): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.S3ArtifactLocation.ReadOnly =
    zio.aws.codepipeline.model.S3ArtifactLocation.wrap(buildAwsValue())
}
object S3ArtifactLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.S3ArtifactLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.S3ArtifactLocation =
      zio.aws.codepipeline.model.S3ArtifactLocation(bucketName, objectKey)
    def bucketName: S3BucketName
    def objectKey: S3ObjectKey
    def getBucketName: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(bucketName)
    def getObjectKey: ZIO[Any, Nothing, S3ObjectKey] = ZIO.succeed(objectKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.S3ArtifactLocation
  ) extends zio.aws.codepipeline.model.S3ArtifactLocation.ReadOnly {
    override val bucketName: S3BucketName =
      zio.aws.codepipeline.model.primitives.S3BucketName(impl.bucketName())
    override val objectKey: S3ObjectKey =
      zio.aws.codepipeline.model.primitives.S3ObjectKey(impl.objectKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.S3ArtifactLocation
  ): zio.aws.codepipeline.model.S3ArtifactLocation.ReadOnly = new Wrapper(impl)
}
