package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  JobTimeout,
  PolicyStatementsTemplate
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ActionTypeExecutor(
    configuration: zio.aws.codepipeline.model.ExecutorConfiguration,
    `type`: zio.aws.codepipeline.model.ExecutorType,
    policyStatementsTemplate: Option[PolicyStatementsTemplate] = None,
    jobTimeout: Option[JobTimeout] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionTypeExecutor = {
    import ActionTypeExecutor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionTypeExecutor
      .builder()
      .configuration(configuration.buildAwsValue())
      .`type`(`type`.unwrap)
      .optionallyWith(
        policyStatementsTemplate.map(value =>
          PolicyStatementsTemplate.unwrap(value): java.lang.String
        )
      )(_.policyStatementsTemplate)
      .optionallyWith(
        jobTimeout.map(value => JobTimeout.unwrap(value): Integer)
      )(_.jobTimeout)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionTypeExecutor.ReadOnly =
    zio.aws.codepipeline.model.ActionTypeExecutor.wrap(buildAwsValue())
}
object ActionTypeExecutor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionTypeExecutor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionTypeExecutor =
      zio.aws.codepipeline.model.ActionTypeExecutor(
        configuration.asEditable,
        `type`,
        policyStatementsTemplate.map(value => value),
        jobTimeout.map(value => value)
      )
    def configuration: zio.aws.codepipeline.model.ExecutorConfiguration.ReadOnly
    def `type`: zio.aws.codepipeline.model.ExecutorType
    def policyStatementsTemplate: Option[PolicyStatementsTemplate]
    def jobTimeout: Option[JobTimeout]
    def getConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.ExecutorConfiguration.ReadOnly
    ] = ZIO.succeed(configuration)
    def getType: ZIO[Any, Nothing, zio.aws.codepipeline.model.ExecutorType] =
      ZIO.succeed(`type`)
    def getPolicyStatementsTemplate
        : ZIO[Any, AwsError, PolicyStatementsTemplate] = AwsError
      .unwrapOptionField("policyStatementsTemplate", policyStatementsTemplate)
    def getJobTimeout: ZIO[Any, AwsError, JobTimeout] =
      AwsError.unwrapOptionField("jobTimeout", jobTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeExecutor
  ) extends zio.aws.codepipeline.model.ActionTypeExecutor.ReadOnly {
    override val configuration
        : zio.aws.codepipeline.model.ExecutorConfiguration.ReadOnly =
      zio.aws.codepipeline.model.ExecutorConfiguration
        .wrap(impl.configuration())
    override val `type`: zio.aws.codepipeline.model.ExecutorType =
      zio.aws.codepipeline.model.ExecutorType.wrap(impl.`type`())
    override val policyStatementsTemplate: Option[PolicyStatementsTemplate] =
      scala
        .Option(impl.policyStatementsTemplate())
        .map(value =>
          zio.aws.codepipeline.model.primitives.PolicyStatementsTemplate(value)
        )
    override val jobTimeout: Option[JobTimeout] = scala
      .Option(impl.jobTimeout())
      .map(value => zio.aws.codepipeline.model.primitives.JobTimeout(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypeExecutor
  ): zio.aws.codepipeline.model.ActionTypeExecutor.ReadOnly = new Wrapper(impl)
}
