package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.PipelineExecutionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StopPipelineExecutionResponse(
    pipelineExecutionId: Option[PipelineExecutionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionResponse = {
    import StopPipelineExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionResponse
      .builder()
      .optionallyWith(
        pipelineExecutionId.map(value =>
          PipelineExecutionId.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionId)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.StopPipelineExecutionResponse.ReadOnly =
    zio.aws.codepipeline.model.StopPipelineExecutionResponse
      .wrap(buildAwsValue())
}
object StopPipelineExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StopPipelineExecutionResponse =
      zio.aws.codepipeline.model
        .StopPipelineExecutionResponse(pipelineExecutionId.map(value => value))
    def pipelineExecutionId: Option[PipelineExecutionId]
    def getPipelineExecutionId: ZIO[Any, AwsError, PipelineExecutionId] =
      AwsError.unwrapOptionField("pipelineExecutionId", pipelineExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionResponse
  ) extends zio.aws.codepipeline.model.StopPipelineExecutionResponse.ReadOnly {
    override val pipelineExecutionId: Option[PipelineExecutionId] = scala
      .Option(impl.pipelineExecutionId())
      .map(value =>
        zio.aws.codepipeline.model.primitives.PipelineExecutionId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StopPipelineExecutionResponse
  ): zio.aws.codepipeline.model.StopPipelineExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
