package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.TriggerDetail
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExecutionTrigger(
    triggerType: Option[zio.aws.codepipeline.model.TriggerType] = None,
    triggerDetail: Option[TriggerDetail] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ExecutionTrigger = {
    import ExecutionTrigger.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ExecutionTrigger
      .builder()
      .optionallyWith(triggerType.map(value => value.unwrap))(_.triggerType)
      .optionallyWith(
        triggerDetail.map(value =>
          TriggerDetail.unwrap(value): java.lang.String
        )
      )(_.triggerDetail)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ExecutionTrigger.ReadOnly =
    zio.aws.codepipeline.model.ExecutionTrigger.wrap(buildAwsValue())
}
object ExecutionTrigger {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ExecutionTrigger
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ExecutionTrigger =
      zio.aws.codepipeline.model.ExecutionTrigger(
        triggerType.map(value => value),
        triggerDetail.map(value => value)
      )
    def triggerType: Option[zio.aws.codepipeline.model.TriggerType]
    def triggerDetail: Option[TriggerDetail]
    def getTriggerType
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.TriggerType] =
      AwsError.unwrapOptionField("triggerType", triggerType)
    def getTriggerDetail: ZIO[Any, AwsError, TriggerDetail] =
      AwsError.unwrapOptionField("triggerDetail", triggerDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ExecutionTrigger
  ) extends zio.aws.codepipeline.model.ExecutionTrigger.ReadOnly {
    override val triggerType: Option[zio.aws.codepipeline.model.TriggerType] =
      scala
        .Option(impl.triggerType())
        .map(value => zio.aws.codepipeline.model.TriggerType.wrap(value))
    override val triggerDetail: Option[TriggerDetail] = scala
      .Option(impl.triggerDetail())
      .map(value => zio.aws.codepipeline.model.primitives.TriggerDetail(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ExecutionTrigger
  ): zio.aws.codepipeline.model.ExecutionTrigger.ReadOnly = new Wrapper(impl)
}
