package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{AccountId, Nonce, JobId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Job(
    id: Option[JobId] = None,
    data: Option[zio.aws.codepipeline.model.JobData] = None,
    nonce: Option[Nonce] = None,
    accountId: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.Job = {
    import Job.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.Job
      .builder()
      .optionallyWith(id.map(value => JobId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(data.map(value => value.buildAwsValue()))(_.data)
      .optionallyWith(
        nonce.map(value => Nonce.unwrap(value): java.lang.String)
      )(_.nonce)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.Job.ReadOnly =
    zio.aws.codepipeline.model.Job.wrap(buildAwsValue())
}
object Job {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codepipeline.model.Job] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.Job =
      zio.aws.codepipeline.model.Job(
        id.map(value => value),
        data.map(value => value.asEditable),
        nonce.map(value => value),
        accountId.map(value => value)
      )
    def id: Option[JobId]
    def data: Option[zio.aws.codepipeline.model.JobData.ReadOnly]
    def nonce: Option[Nonce]
    def accountId: Option[AccountId]
    def getId: ZIO[Any, AwsError, JobId] = AwsError.unwrapOptionField("id", id)
    def getData
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.JobData.ReadOnly] =
      AwsError.unwrapOptionField("data", data)
    def getNonce: ZIO[Any, AwsError, Nonce] =
      AwsError.unwrapOptionField("nonce", nonce)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.Job
  ) extends zio.aws.codepipeline.model.Job.ReadOnly {
    override val id: Option[JobId] = scala
      .Option(impl.id())
      .map(value => zio.aws.codepipeline.model.primitives.JobId(value))
    override val data: Option[zio.aws.codepipeline.model.JobData.ReadOnly] =
      scala
        .Option(impl.data())
        .map(value => zio.aws.codepipeline.model.JobData.wrap(value))
    override val nonce: Option[Nonce] = scala
      .Option(impl.nonce())
      .map(value => zio.aws.codepipeline.model.primitives.Nonce(value))
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.codepipeline.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.Job
  ): zio.aws.codepipeline.model.Job.ReadOnly = new Wrapper(impl)
}
