package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.{TagValue, TagKey, ScanNameArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: ScanNameArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.TagResourceRequest
      .builder()
      .resourceArn(ScanNameArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.TagResourceRequest.ReadOnly =
    zio.aws.codegurusecurity.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.TagResourceRequest =
      zio.aws.codegurusecurity.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: ScanNameArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, ScanNameArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.TagResourceRequest
  ) extends zio.aws.codegurusecurity.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ScanNameArn =
      zio.aws.codegurusecurity.model.primitives.ScanNameArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.codegurusecurity.model.primitives.TagKey(
          key
        ) -> zio.aws.codegurusecurity.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.TagResourceRequest
  ): zio.aws.codegurusecurity.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
