package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.{ScanName, Uuid}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetScanRequest(
    runId: Optional[Uuid] = Optional.Absent,
    scanName: ScanName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.GetScanRequest = {
    import GetScanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.GetScanRequest
      .builder()
      .optionallyWith(runId.map(value => Uuid.unwrap(value): java.lang.String))(
        _.runId
      )
      .scanName(ScanName.unwrap(scanName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.GetScanRequest.ReadOnly =
    zio.aws.codegurusecurity.model.GetScanRequest.wrap(buildAwsValue())
}
object GetScanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.GetScanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.GetScanRequest =
      zio.aws.codegurusecurity.model
        .GetScanRequest(runId.map(value => value), scanName)
    def runId: Optional[Uuid]
    def scanName: ScanName
    def getRunId: ZIO[Any, AwsError, Uuid] =
      AwsError.unwrapOptionField("runId", runId)
    def getScanName: ZIO[Any, Nothing, ScanName] = ZIO.succeed(scanName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.GetScanRequest
  ) extends zio.aws.codegurusecurity.model.GetScanRequest.ReadOnly {
    override val runId: Optional[Uuid] = zio.aws.core.internal
      .optionalFromNullable(impl.runId())
      .map(value => zio.aws.codegurusecurity.model.primitives.Uuid(value))
    override val scanName: ScanName =
      zio.aws.codegurusecurity.model.primitives.ScanName(impl.scanName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.GetScanRequest
  ): zio.aws.codegurusecurity.model.GetScanRequest.ReadOnly = new Wrapper(impl)
}
