package zio.aws.codegurusecurity.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetMetricsSummaryResponse(
    metricsSummary: Optional[zio.aws.codegurusecurity.model.MetricsSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryResponse = {
    import GetMetricsSummaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryResponse
      .builder()
      .optionallyWith(metricsSummary.map(value => value.buildAwsValue()))(
        _.metricsSummary
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.GetMetricsSummaryResponse.ReadOnly =
    zio.aws.codegurusecurity.model.GetMetricsSummaryResponse
      .wrap(buildAwsValue())
}
object GetMetricsSummaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.GetMetricsSummaryResponse =
      zio.aws.codegurusecurity.model.GetMetricsSummaryResponse(
        metricsSummary.map(value => value.asEditable)
      )
    def metricsSummary
        : Optional[zio.aws.codegurusecurity.model.MetricsSummary.ReadOnly]
    def getMetricsSummary: ZIO[
      Any,
      AwsError,
      zio.aws.codegurusecurity.model.MetricsSummary.ReadOnly
    ] = AwsError.unwrapOptionField("metricsSummary", metricsSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryResponse
  ) extends zio.aws.codegurusecurity.model.GetMetricsSummaryResponse.ReadOnly {
    override val metricsSummary
        : Optional[zio.aws.codegurusecurity.model.MetricsSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricsSummary())
        .map(value => zio.aws.codegurusecurity.model.MetricsSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.GetMetricsSummaryResponse
  ): zio.aws.codegurusecurity.model.GetMetricsSummaryResponse.ReadOnly =
    new Wrapper(impl)
}
