package zio.aws.codegurusecurity.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codegurusecurity.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class AccountFindingsMetric(
    closedFindings: Optional[
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity
    ] = Optional.Absent,
    date: Optional[Timestamp] = Optional.Absent,
    meanTimeToClose: Optional[
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity
    ] = Optional.Absent,
    newFindings: Optional[
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity
    ] = Optional.Absent,
    openFindings: Optional[
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.AccountFindingsMetric = {
    import AccountFindingsMetric.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.AccountFindingsMetric
      .builder()
      .optionallyWith(closedFindings.map(value => value.buildAwsValue()))(
        _.closedFindings
      )
      .optionallyWith(date.map(value => Timestamp.unwrap(value): Instant))(
        _.date
      )
      .optionallyWith(meanTimeToClose.map(value => value.buildAwsValue()))(
        _.meanTimeToClose
      )
      .optionallyWith(newFindings.map(value => value.buildAwsValue()))(
        _.newFindings
      )
      .optionallyWith(openFindings.map(value => value.buildAwsValue()))(
        _.openFindings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.AccountFindingsMetric.ReadOnly =
    zio.aws.codegurusecurity.model.AccountFindingsMetric.wrap(buildAwsValue())
}
object AccountFindingsMetric {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.AccountFindingsMetric
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.AccountFindingsMetric =
      zio.aws.codegurusecurity.model.AccountFindingsMetric(
        closedFindings.map(value => value.asEditable),
        date.map(value => value),
        meanTimeToClose.map(value => value.asEditable),
        newFindings.map(value => value.asEditable),
        openFindings.map(value => value.asEditable)
      )
    def closedFindings: Optional[
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly
    ]
    def date: Optional[Timestamp]
    def meanTimeToClose: Optional[
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly
    ]
    def newFindings: Optional[
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly
    ]
    def openFindings: Optional[
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly
    ]
    def getClosedFindings: ZIO[
      Any,
      AwsError,
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly
    ] = AwsError.unwrapOptionField("closedFindings", closedFindings)
    def getDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("date", date)
    def getMeanTimeToClose: ZIO[
      Any,
      AwsError,
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly
    ] = AwsError.unwrapOptionField("meanTimeToClose", meanTimeToClose)
    def getNewFindings: ZIO[
      Any,
      AwsError,
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly
    ] = AwsError.unwrapOptionField("newFindings", newFindings)
    def getOpenFindings: ZIO[
      Any,
      AwsError,
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly
    ] = AwsError.unwrapOptionField("openFindings", openFindings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.AccountFindingsMetric
  ) extends zio.aws.codegurusecurity.model.AccountFindingsMetric.ReadOnly {
    override val closedFindings: Optional[
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.closedFindings())
      .map(value =>
        zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity
          .wrap(value)
      )
    override val date: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.date())
      .map(value => zio.aws.codegurusecurity.model.primitives.Timestamp(value))
    override val meanTimeToClose: Optional[
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.meanTimeToClose())
      .map(value =>
        zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity
          .wrap(value)
      )
    override val newFindings: Optional[
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.newFindings())
      .map(value =>
        zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity
          .wrap(value)
      )
    override val openFindings: Optional[
      zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.openFindings())
      .map(value =>
        zio.aws.codegurusecurity.model.FindingMetricsValuePerSeverity
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.AccountFindingsMetric
  ): zio.aws.codegurusecurity.model.AccountFindingsMetric.ReadOnly =
    new Wrapper(impl)
}
