package zio.aws.codegurusecurity
import zio.aws.codegurusecurity.model.primitives.{
  TagValue,
  TagKey,
  HeaderValue,
  HeaderKey
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.codegurusecurity.model.primitives.TagValue.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ClientToken extends Subtype[String]
    type ClientToken =
      zio.aws.codegurusecurity.model.primitives.ClientToken.Type
    object GetFindingsRequestMaxResultsInteger extends Subtype[Int]
    type GetFindingsRequestMaxResultsInteger =
      zio.aws.codegurusecurity.model.primitives.GetFindingsRequestMaxResultsInteger.Type
    object HeaderKey extends Subtype[String]
    type HeaderKey = zio.aws.codegurusecurity.model.primitives.HeaderKey.Type
    object HeaderValue extends Subtype[String]
    type HeaderValue =
      zio.aws.codegurusecurity.model.primitives.HeaderValue.Type
    type Integer = Int
    object KmsKeyArn extends Subtype[String]
    type KmsKeyArn = zio.aws.codegurusecurity.model.primitives.KmsKeyArn.Type
    object ListFindingsMetricsRequestMaxResultsInteger extends Subtype[Int]
    type ListFindingsMetricsRequestMaxResultsInteger =
      zio.aws.codegurusecurity.model.primitives.ListFindingsMetricsRequestMaxResultsInteger.Type
    object ListScansRequestMaxResultsInteger extends Subtype[Int]
    type ListScansRequestMaxResultsInteger =
      zio.aws.codegurusecurity.model.primitives.ListScansRequestMaxResultsInteger.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.codegurusecurity.model.primitives.NextToken.Type
    object S3Url extends Subtype[String]
    type S3Url = zio.aws.codegurusecurity.model.primitives.S3Url.Type
    object ScanName extends Subtype[String]
    type ScanName = zio.aws.codegurusecurity.model.primitives.ScanName.Type
    object ScanNameArn extends Subtype[String]
    type ScanNameArn =
      zio.aws.codegurusecurity.model.primitives.ScanNameArn.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.codegurusecurity.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.codegurusecurity.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.codegurusecurity.model.primitives.Timestamp.Type
    object Uuid extends Subtype[String]
    type Uuid = zio.aws.codegurusecurity.model.primitives.Uuid.Type
  }
  type BatchGetFindingsErrors =
    List[zio.aws.codegurusecurity.model.BatchGetFindingsError]
  type CategoriesWithMostFindings =
    List[zio.aws.codegurusecurity.model.CategoryWithFindingNum]
  type CodeSnippet = List[zio.aws.codegurusecurity.model.CodeLine]
  type DetectorTags = List[String]
  type FindingIdentifiers =
    List[zio.aws.codegurusecurity.model.FindingIdentifier]
  type Findings = List[zio.aws.codegurusecurity.model.Finding]
  type FindingsMetricList =
    List[zio.aws.codegurusecurity.model.AccountFindingsMetric]
  type ReferenceUrls = List[String]
  type RelatedVulnerabilities = List[String]
  type RequestHeaderMap = Map[HeaderKey, HeaderValue]
  type ScanSummaries = List[zio.aws.codegurusecurity.model.ScanSummary]
  type ScansWithMostOpenCriticalFindings =
    List[zio.aws.codegurusecurity.model.ScanNameWithFindingNum]
  type ScansWithMostOpenFindings =
    List[zio.aws.codegurusecurity.model.ScanNameWithFindingNum]
  type SuggestedFixes = List[zio.aws.codegurusecurity.model.SuggestedFix]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
}
