package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FilePath(
    codeSnippet: Optional[Iterable[zio.aws.codegurusecurity.model.CodeLine]] =
      Optional.Absent,
    endLine: Optional[Integer] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    path: Optional[String] = Optional.Absent,
    startLine: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.FilePath = {
    import FilePath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.FilePath
      .builder()
      .optionallyWith(
        codeSnippet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.codeSnippet)
      .optionallyWith(endLine.map(value => value: java.lang.Integer))(_.endLine)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(path.map(value => value: java.lang.String))(_.path)
      .optionallyWith(startLine.map(value => value: java.lang.Integer))(
        _.startLine
      )
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.FilePath.ReadOnly =
    zio.aws.codegurusecurity.model.FilePath.wrap(buildAwsValue())
}
object FilePath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.FilePath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.FilePath =
      zio.aws.codegurusecurity.model.FilePath(
        codeSnippet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        endLine.map(value => value),
        name.map(value => value),
        path.map(value => value),
        startLine.map(value => value)
      )
    def codeSnippet
        : Optional[List[zio.aws.codegurusecurity.model.CodeLine.ReadOnly]]
    def endLine: Optional[Integer]
    def name: Optional[String]
    def path: Optional[String]
    def startLine: Optional[Integer]
    def getCodeSnippet: ZIO[Any, AwsError, List[
      zio.aws.codegurusecurity.model.CodeLine.ReadOnly
    ]] = AwsError.unwrapOptionField("codeSnippet", codeSnippet)
    def getEndLine: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endLine", endLine)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("path", path)
    def getStartLine: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("startLine", startLine)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.FilePath
  ) extends zio.aws.codegurusecurity.model.FilePath.ReadOnly {
    override val codeSnippet
        : Optional[List[zio.aws.codegurusecurity.model.CodeLine.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeSnippet())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codegurusecurity.model.CodeLine.wrap(item)
          }.toList
        )
    override val endLine: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.endLine())
      .map(value => value: Integer)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val path: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => value: String)
    override val startLine: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.startLine())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.FilePath
  ): zio.aws.codegurusecurity.model.FilePath.ReadOnly = new Wrapper(impl)
}
