package zio.aws.codegurusecurity.model
import scala.jdk.CollectionConverters.*
sealed trait Status {
  def unwrap: software.amazon.awssdk.services.codegurusecurity.model.Status
}
object Status {
  def wrap(
      value: software.amazon.awssdk.services.codegurusecurity.model.Status
  ): zio.aws.codegurusecurity.model.Status = value match {
    case software.amazon.awssdk.services.codegurusecurity.model.Status.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurusecurity.model.Status.CLOSED =>
      val r = Closed
      r
    case software.amazon.awssdk.services.codegurusecurity.model.Status.OPEN =>
      val r = Open
      r
    case software.amazon.awssdk.services.codegurusecurity.model.Status.ALL =>
      val r = All
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurusecurity.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.Status =
      software.amazon.awssdk.services.codegurusecurity.model.Status.UNKNOWN_TO_SDK_VERSION
  }
  case object Closed extends zio.aws.codegurusecurity.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.Status =
      software.amazon.awssdk.services.codegurusecurity.model.Status.CLOSED
  }
  case object Open extends zio.aws.codegurusecurity.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.Status =
      software.amazon.awssdk.services.codegurusecurity.model.Status.OPEN
  }
  case object All extends zio.aws.codegurusecurity.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.Status =
      software.amazon.awssdk.services.codegurusecurity.model.Status.ALL
  }
}
