package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFindingsMetricsResponse(
    findingsMetrics: Optional[
      Iterable[zio.aws.codegurusecurity.model.AccountFindingsMetric]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsResponse = {
    import ListFindingsMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsResponse
      .builder()
      .optionallyWith(
        findingsMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.findingsMetrics)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codegurusecurity.model.ListFindingsMetricsResponse.ReadOnly =
    zio.aws.codegurusecurity.model.ListFindingsMetricsResponse
      .wrap(buildAwsValue())
}
object ListFindingsMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.ListFindingsMetricsResponse =
      zio.aws.codegurusecurity.model.ListFindingsMetricsResponse(
        findingsMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def findingsMetrics: Optional[
      List[zio.aws.codegurusecurity.model.AccountFindingsMetric.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getFindingsMetrics: ZIO[Any, AwsError, List[
      zio.aws.codegurusecurity.model.AccountFindingsMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("findingsMetrics", findingsMetrics)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsResponse
  ) extends zio.aws.codegurusecurity.model.ListFindingsMetricsResponse.ReadOnly {
    override val findingsMetrics: Optional[
      List[zio.aws.codegurusecurity.model.AccountFindingsMetric.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.findingsMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codegurusecurity.model.AccountFindingsMetric.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.codegurusecurity.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.ListFindingsMetricsResponse
  ): zio.aws.codegurusecurity.model.ListFindingsMetricsResponse.ReadOnly =
    new Wrapper(impl)
}
