package zio.aws.codegurusecurity.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codegurusecurity.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class Finding(
    createdAt: Optional[Timestamp] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    detectorId: Optional[String] = Optional.Absent,
    detectorName: Optional[String] = Optional.Absent,
    detectorTags: Optional[Iterable[String]] = Optional.Absent,
    generatorId: Optional[String] = Optional.Absent,
    id: Optional[String] = Optional.Absent,
    remediation: Optional[zio.aws.codegurusecurity.model.Remediation] =
      Optional.Absent,
    resource: Optional[zio.aws.codegurusecurity.model.Resource] =
      Optional.Absent,
    ruleId: Optional[String] = Optional.Absent,
    severity: Optional[zio.aws.codegurusecurity.model.Severity] =
      Optional.Absent,
    status: Optional[zio.aws.codegurusecurity.model.Status] = Optional.Absent,
    title: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    vulnerability: Optional[zio.aws.codegurusecurity.model.Vulnerability] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.Finding = {
    import Finding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.Finding
      .builder()
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(detectorId.map(value => value: java.lang.String))(
        _.detectorId
      )
      .optionallyWith(detectorName.map(value => value: java.lang.String))(
        _.detectorName
      )
      .optionallyWith(
        detectorTags.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.detectorTags)
      .optionallyWith(generatorId.map(value => value: java.lang.String))(
        _.generatorId
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(remediation.map(value => value.buildAwsValue()))(
        _.remediation
      )
      .optionallyWith(resource.map(value => value.buildAwsValue()))(_.resource)
      .optionallyWith(ruleId.map(value => value: java.lang.String))(_.ruleId)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(vulnerability.map(value => value.buildAwsValue()))(
        _.vulnerability
      )
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.Finding.ReadOnly =
    zio.aws.codegurusecurity.model.Finding.wrap(buildAwsValue())
}
object Finding {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.Finding
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.Finding =
      zio.aws.codegurusecurity.model.Finding(
        createdAt.map(value => value),
        description.map(value => value),
        detectorId.map(value => value),
        detectorName.map(value => value),
        detectorTags.map(value => value),
        generatorId.map(value => value),
        id.map(value => value),
        remediation.map(value => value.asEditable),
        resource.map(value => value.asEditable),
        ruleId.map(value => value),
        severity.map(value => value),
        status.map(value => value),
        title.map(value => value),
        `type`.map(value => value),
        updatedAt.map(value => value),
        vulnerability.map(value => value.asEditable)
      )
    def createdAt: Optional[Timestamp]
    def description: Optional[String]
    def detectorId: Optional[String]
    def detectorName: Optional[String]
    def detectorTags: Optional[List[String]]
    def generatorId: Optional[String]
    def id: Optional[String]
    def remediation
        : Optional[zio.aws.codegurusecurity.model.Remediation.ReadOnly]
    def resource: Optional[zio.aws.codegurusecurity.model.Resource.ReadOnly]
    def ruleId: Optional[String]
    def severity: Optional[zio.aws.codegurusecurity.model.Severity]
    def status: Optional[zio.aws.codegurusecurity.model.Status]
    def title: Optional[String]
    def `type`: Optional[String]
    def updatedAt: Optional[Timestamp]
    def vulnerability
        : Optional[zio.aws.codegurusecurity.model.Vulnerability.ReadOnly]
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDetectorId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("detectorId", detectorId)
    def getDetectorName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("detectorName", detectorName)
    def getDetectorTags: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("detectorTags", detectorTags)
    def getGeneratorId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("generatorId", generatorId)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getRemediation: ZIO[
      Any,
      AwsError,
      zio.aws.codegurusecurity.model.Remediation.ReadOnly
    ] = AwsError.unwrapOptionField("remediation", remediation)
    def getResource
        : ZIO[Any, AwsError, zio.aws.codegurusecurity.model.Resource.ReadOnly] =
      AwsError.unwrapOptionField("resource", resource)
    def getRuleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleId", ruleId)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.codegurusecurity.model.Severity] =
      AwsError.unwrapOptionField("severity", severity)
    def getStatus: ZIO[Any, AwsError, zio.aws.codegurusecurity.model.Status] =
      AwsError.unwrapOptionField("status", status)
    def getTitle: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("title", title)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getVulnerability: ZIO[
      Any,
      AwsError,
      zio.aws.codegurusecurity.model.Vulnerability.ReadOnly
    ] = AwsError.unwrapOptionField("vulnerability", vulnerability)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.Finding
  ) extends zio.aws.codegurusecurity.model.Finding.ReadOnly {
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.codegurusecurity.model.primitives.Timestamp(value))
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val detectorId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.detectorId())
      .map(value => value: String)
    override val detectorName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.detectorName())
      .map(value => value: String)
    override val detectorTags: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.detectorTags())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val generatorId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.generatorId())
      .map(value => value: String)
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val remediation
        : Optional[zio.aws.codegurusecurity.model.Remediation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remediation())
        .map(value => zio.aws.codegurusecurity.model.Remediation.wrap(value))
    override val resource
        : Optional[zio.aws.codegurusecurity.model.Resource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resource())
        .map(value => zio.aws.codegurusecurity.model.Resource.wrap(value))
    override val ruleId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleId())
      .map(value => value: String)
    override val severity: Optional[zio.aws.codegurusecurity.model.Severity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value => zio.aws.codegurusecurity.model.Severity.wrap(value))
    override val status: Optional[zio.aws.codegurusecurity.model.Status] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.codegurusecurity.model.Status.wrap(value))
    override val title: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.codegurusecurity.model.primitives.Timestamp(value))
    override val vulnerability
        : Optional[zio.aws.codegurusecurity.model.Vulnerability.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vulnerability())
        .map(value => zio.aws.codegurusecurity.model.Vulnerability.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.Finding
  ): zio.aws.codegurusecurity.model.Finding.ReadOnly = new Wrapper(impl)
}
