package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.{
  TagValue,
  TagKey,
  ScanName,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateScanRequest(
    analysisType: Optional[zio.aws.codegurusecurity.model.AnalysisType] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    resourceId: zio.aws.codegurusecurity.model.ResourceId,
    scanName: ScanName,
    scanType: Optional[zio.aws.codegurusecurity.model.ScanType] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.CreateScanRequest = {
    import CreateScanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.CreateScanRequest
      .builder()
      .optionallyWith(analysisType.map(value => value.unwrap))(_.analysisType)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .resourceId(resourceId.buildAwsValue())
      .scanName(ScanName.unwrap(scanName): java.lang.String)
      .optionallyWith(scanType.map(value => value.unwrap))(_.scanType)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.CreateScanRequest.ReadOnly =
    zio.aws.codegurusecurity.model.CreateScanRequest.wrap(buildAwsValue())
}
object CreateScanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.CreateScanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.CreateScanRequest =
      zio.aws.codegurusecurity.model.CreateScanRequest(
        analysisType.map(value => value),
        clientToken.map(value => value),
        resourceId.asEditable,
        scanName,
        scanType.map(value => value),
        tags.map(value => value)
      )
    def analysisType: Optional[zio.aws.codegurusecurity.model.AnalysisType]
    def clientToken: Optional[ClientToken]
    def resourceId: zio.aws.codegurusecurity.model.ResourceId.ReadOnly
    def scanName: ScanName
    def scanType: Optional[zio.aws.codegurusecurity.model.ScanType]
    def tags: Optional[Map[TagKey, TagValue]]
    def getAnalysisType
        : ZIO[Any, AwsError, zio.aws.codegurusecurity.model.AnalysisType] =
      AwsError.unwrapOptionField("analysisType", analysisType)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getResourceId: ZIO[
      Any,
      Nothing,
      zio.aws.codegurusecurity.model.ResourceId.ReadOnly
    ] = ZIO.succeed(resourceId)
    def getScanName: ZIO[Any, Nothing, ScanName] = ZIO.succeed(scanName)
    def getScanType
        : ZIO[Any, AwsError, zio.aws.codegurusecurity.model.ScanType] =
      AwsError.unwrapOptionField("scanType", scanType)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.CreateScanRequest
  ) extends zio.aws.codegurusecurity.model.CreateScanRequest.ReadOnly {
    override val analysisType
        : Optional[zio.aws.codegurusecurity.model.AnalysisType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analysisType())
        .map(value => zio.aws.codegurusecurity.model.AnalysisType.wrap(value))
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.codegurusecurity.model.primitives.ClientToken(value)
      )
    override val resourceId
        : zio.aws.codegurusecurity.model.ResourceId.ReadOnly =
      zio.aws.codegurusecurity.model.ResourceId.wrap(impl.resourceId())
    override val scanName: ScanName =
      zio.aws.codegurusecurity.model.primitives.ScanName(impl.scanName())
    override val scanType: Optional[zio.aws.codegurusecurity.model.ScanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanType())
        .map(value => zio.aws.codegurusecurity.model.ScanType.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codegurusecurity.model.primitives.TagKey(
              key
            ) -> zio.aws.codegurusecurity.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.CreateScanRequest
  ): zio.aws.codegurusecurity.model.CreateScanRequest.ReadOnly = new Wrapper(
    impl
  )
}
