package zio.aws.codegurusecurity
import zio.aws.codegurusecurity.model.AccountFindingsMetric.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.codegurusecurity.model.{
  BatchGetFindingsResponse,
  ListFindingsMetricsRequest,
  GetMetricsSummaryResponse,
  GetAccountConfigurationResponse,
  GetScanResponse,
  GetMetricsSummaryRequest,
  GetScanRequest,
  GetAccountConfigurationRequest,
  CreateUploadUrlRequest,
  AccountFindingsMetric,
  GetFindingsResponse,
  ListTagsForResourceRequest,
  UpdateAccountConfigurationRequest,
  GetFindingsRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  BatchGetFindingsRequest,
  CreateScanRequest,
  ListScansResponse,
  UpdateAccountConfigurationResponse,
  UntagResourceRequest,
  CreateUploadUrlResponse,
  ListFindingsMetricsResponse,
  ListScansRequest,
  CreateScanResponse,
  ScanSummary,
  Finding,
  TagResourceResponse,
  TagResourceRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.codegurusecurity.paginators.{
  ListFindingsMetricsPublisher,
  ListScansPublisher,
  GetFindingsPublisher
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.codegurusecurity.{
  CodeGuruSecurityAsyncClientBuilder,
  CodeGuruSecurityAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait CodeGuruSecurity extends AspectSupport[CodeGuruSecurity] {
  val api: CodeGuruSecurityAsyncClient
  def createUploadUrl(
      request: zio.aws.codegurusecurity.model.CreateUploadUrlRequest
  ): IO[
    AwsError,
    zio.aws.codegurusecurity.model.CreateUploadUrlResponse.ReadOnly
  ]
  def updateAccountConfiguration(
      request: zio.aws.codegurusecurity.model.UpdateAccountConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.codegurusecurity.model.UpdateAccountConfigurationResponse.ReadOnly
  ]
  def batchGetFindings(
      request: zio.aws.codegurusecurity.model.BatchGetFindingsRequest
  ): IO[
    AwsError,
    zio.aws.codegurusecurity.model.BatchGetFindingsResponse.ReadOnly
  ]
  def getScan(
      request: zio.aws.codegurusecurity.model.GetScanRequest
  ): IO[AwsError, zio.aws.codegurusecurity.model.GetScanResponse.ReadOnly]
  def createScan(
      request: zio.aws.codegurusecurity.model.CreateScanRequest
  ): IO[AwsError, zio.aws.codegurusecurity.model.CreateScanResponse.ReadOnly]
  def getMetricsSummary(
      request: zio.aws.codegurusecurity.model.GetMetricsSummaryRequest
  ): IO[
    AwsError,
    zio.aws.codegurusecurity.model.GetMetricsSummaryResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.codegurusecurity.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.codegurusecurity.model.UntagResourceResponse.ReadOnly]
  def getFindings(
      request: zio.aws.codegurusecurity.model.GetFindingsRequest
  ): ZStream[Any, AwsError, zio.aws.codegurusecurity.model.Finding.ReadOnly]
  def getFindingsPaginated(
      request: zio.aws.codegurusecurity.model.GetFindingsRequest
  ): IO[AwsError, zio.aws.codegurusecurity.model.GetFindingsResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.codegurusecurity.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.codegurusecurity.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.codegurusecurity.model.TagResourceRequest
  ): IO[AwsError, zio.aws.codegurusecurity.model.TagResourceResponse.ReadOnly]
  def listScans(
      request: zio.aws.codegurusecurity.model.ListScansRequest
  ): ZStream[Any, AwsError, zio.aws.codegurusecurity.model.ScanSummary.ReadOnly]
  def listScansPaginated(
      request: zio.aws.codegurusecurity.model.ListScansRequest
  ): IO[AwsError, zio.aws.codegurusecurity.model.ListScansResponse.ReadOnly]
  def listFindingsMetrics(
      request: zio.aws.codegurusecurity.model.ListFindingsMetricsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listFindingsMetricsPaginated(
      request: zio.aws.codegurusecurity.model.ListFindingsMetricsRequest
  ): IO[
    AwsError,
    zio.aws.codegurusecurity.model.ListFindingsMetricsResponse.ReadOnly
  ]
  def getAccountConfiguration(
      request: zio.aws.codegurusecurity.model.GetAccountConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.codegurusecurity.model.GetAccountConfigurationResponse.ReadOnly
  ]
}
object CodeGuruSecurity {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CodeGuruSecurity] =
    customized(identity)
  def customized(
      customization: CodeGuruSecurityAsyncClientBuilder => CodeGuruSecurityAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CodeGuruSecurity] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: CodeGuruSecurityAsyncClientBuilder => CodeGuruSecurityAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, CodeGuruSecurity] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = CodeGuruSecurityAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      CodeGuruSecurityAsyncClient,
      CodeGuruSecurityAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      CodeGuruSecurityAsyncClient,
      CodeGuruSecurityAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new CodeGuruSecurityImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class CodeGuruSecurityImpl[R](
      override val api: CodeGuruSecurityAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CodeGuruSecurity
      with AwsServiceBase[R] {
    override val serviceName: String = "CodeGuruSecurity"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CodeGuruSecurityImpl[R1] = new CodeGuruSecurityImpl(api, newAspect, r)
    def createUploadUrl(
        request: zio.aws.codegurusecurity.model.CreateUploadUrlRequest
    ): IO[
      AwsError,
      zio.aws.codegurusecurity.model.CreateUploadUrlResponse.ReadOnly
    ] = asyncRequestResponse[CreateUploadUrlRequest, CreateUploadUrlResponse](
      "createUploadUrl",
      api.createUploadUrl
    )(request.buildAwsValue())
      .map(zio.aws.codegurusecurity.model.CreateUploadUrlResponse.wrap)
      .provideEnvironment(r)
    def updateAccountConfiguration(
        request: zio.aws.codegurusecurity.model.UpdateAccountConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.codegurusecurity.model.UpdateAccountConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateAccountConfigurationRequest,
      UpdateAccountConfigurationResponse
    ]("updateAccountConfiguration", api.updateAccountConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.codegurusecurity.model.UpdateAccountConfigurationResponse.wrap
    ).provideEnvironment(r)
    def batchGetFindings(
        request: zio.aws.codegurusecurity.model.BatchGetFindingsRequest
    ): IO[
      AwsError,
      zio.aws.codegurusecurity.model.BatchGetFindingsResponse.ReadOnly
    ] = asyncRequestResponse[BatchGetFindingsRequest, BatchGetFindingsResponse](
      "batchGetFindings",
      api.batchGetFindings
    )(request.buildAwsValue())
      .map(zio.aws.codegurusecurity.model.BatchGetFindingsResponse.wrap)
      .provideEnvironment(r)
    def getScan(
        request: zio.aws.codegurusecurity.model.GetScanRequest
    ): IO[AwsError, zio.aws.codegurusecurity.model.GetScanResponse.ReadOnly] =
      asyncRequestResponse[GetScanRequest, GetScanResponse](
        "getScan",
        api.getScan
      )(request.buildAwsValue())
        .map(zio.aws.codegurusecurity.model.GetScanResponse.wrap)
        .provideEnvironment(r)
    def createScan(
        request: zio.aws.codegurusecurity.model.CreateScanRequest
    ): IO[
      AwsError,
      zio.aws.codegurusecurity.model.CreateScanResponse.ReadOnly
    ] = asyncRequestResponse[CreateScanRequest, CreateScanResponse](
      "createScan",
      api.createScan
    )(request.buildAwsValue())
      .map(zio.aws.codegurusecurity.model.CreateScanResponse.wrap)
      .provideEnvironment(r)
    def getMetricsSummary(
        request: zio.aws.codegurusecurity.model.GetMetricsSummaryRequest
    ): IO[
      AwsError,
      zio.aws.codegurusecurity.model.GetMetricsSummaryResponse.ReadOnly
    ] =
      asyncRequestResponse[GetMetricsSummaryRequest, GetMetricsSummaryResponse](
        "getMetricsSummary",
        api.getMetricsSummary
      )(request.buildAwsValue())
        .map(zio.aws.codegurusecurity.model.GetMetricsSummaryResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.codegurusecurity.model.UntagResourceRequest
    ): IO[
      AwsError,
      zio.aws.codegurusecurity.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(zio.aws.codegurusecurity.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def getFindings(
        request: zio.aws.codegurusecurity.model.GetFindingsRequest
    ): ZStream[Any, AwsError, zio.aws.codegurusecurity.model.Finding.ReadOnly] =
      asyncJavaPaginatedRequest[
        GetFindingsRequest,
        Finding,
        GetFindingsPublisher
      ]("getFindings", api.getFindingsPaginator, _.findings())(
        request.buildAwsValue()
      ).map(item => zio.aws.codegurusecurity.model.Finding.wrap(item))
        .provideEnvironment(r)
    def getFindingsPaginated(
        request: zio.aws.codegurusecurity.model.GetFindingsRequest
    ): IO[
      AwsError,
      zio.aws.codegurusecurity.model.GetFindingsResponse.ReadOnly
    ] = asyncRequestResponse[GetFindingsRequest, GetFindingsResponse](
      "getFindings",
      api.getFindings
    )(request.buildAwsValue())
      .map(zio.aws.codegurusecurity.model.GetFindingsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.codegurusecurity.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.codegurusecurity.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.codegurusecurity.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.codegurusecurity.model.TagResourceRequest
    ): IO[
      AwsError,
      zio.aws.codegurusecurity.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[TagResourceRequest, TagResourceResponse](
      "tagResource",
      api.tagResource
    )(request.buildAwsValue())
      .map(zio.aws.codegurusecurity.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def listScans(
        request: zio.aws.codegurusecurity.model.ListScansRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.codegurusecurity.model.ScanSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListScansRequest,
      ScanSummary,
      ListScansPublisher
    ]("listScans", api.listScansPaginator, _.summaries())(
      request.buildAwsValue()
    ).map(item => zio.aws.codegurusecurity.model.ScanSummary.wrap(item))
      .provideEnvironment(r)
    def listScansPaginated(
        request: zio.aws.codegurusecurity.model.ListScansRequest
    ): IO[AwsError, zio.aws.codegurusecurity.model.ListScansResponse.ReadOnly] =
      asyncRequestResponse[ListScansRequest, ListScansResponse](
        "listScans",
        api.listScans
      )(request.buildAwsValue())
        .map(zio.aws.codegurusecurity.model.ListScansResponse.wrap)
        .provideEnvironment(r)
    def listFindingsMetrics(
        request: zio.aws.codegurusecurity.model.ListFindingsMetricsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncJavaPaginatedRequest[
      ListFindingsMetricsRequest,
      AccountFindingsMetric,
      ListFindingsMetricsPublisher
    ](
      "listFindingsMetrics",
      api.listFindingsMetricsPaginator,
      _.findingsMetrics()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.codegurusecurity.model.AccountFindingsMetric.wrap(item)
      )
      .provideEnvironment(r)
    def listFindingsMetricsPaginated(
        request: zio.aws.codegurusecurity.model.ListFindingsMetricsRequest
    ): IO[
      AwsError,
      zio.aws.codegurusecurity.model.ListFindingsMetricsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListFindingsMetricsRequest,
      ListFindingsMetricsResponse
    ]("listFindingsMetrics", api.listFindingsMetrics)(request.buildAwsValue())
      .map(zio.aws.codegurusecurity.model.ListFindingsMetricsResponse.wrap)
      .provideEnvironment(r)
    def getAccountConfiguration(
        request: zio.aws.codegurusecurity.model.GetAccountConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.codegurusecurity.model.GetAccountConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAccountConfigurationRequest,
      GetAccountConfigurationResponse
    ]("getAccountConfiguration", api.getAccountConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.codegurusecurity.model.GetAccountConfigurationResponse.wrap)
      .provideEnvironment(r)
  }
  def createUploadUrl(
      request: zio.aws.codegurusecurity.model.CreateUploadUrlRequest
  ): ZIO[
    zio.aws.codegurusecurity.CodeGuruSecurity,
    AwsError,
    zio.aws.codegurusecurity.model.CreateUploadUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUploadUrl(request))
  def updateAccountConfiguration(
      request: zio.aws.codegurusecurity.model.UpdateAccountConfigurationRequest
  ): ZIO[
    zio.aws.codegurusecurity.CodeGuruSecurity,
    AwsError,
    zio.aws.codegurusecurity.model.UpdateAccountConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAccountConfiguration(request))
  def batchGetFindings(
      request: zio.aws.codegurusecurity.model.BatchGetFindingsRequest
  ): ZIO[
    zio.aws.codegurusecurity.CodeGuruSecurity,
    AwsError,
    zio.aws.codegurusecurity.model.BatchGetFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetFindings(request))
  def getScan(request: zio.aws.codegurusecurity.model.GetScanRequest): ZIO[
    zio.aws.codegurusecurity.CodeGuruSecurity,
    AwsError,
    zio.aws.codegurusecurity.model.GetScanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getScan(request))
  def createScan(
      request: zio.aws.codegurusecurity.model.CreateScanRequest
  ): ZIO[
    zio.aws.codegurusecurity.CodeGuruSecurity,
    AwsError,
    zio.aws.codegurusecurity.model.CreateScanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createScan(request))
  def getMetricsSummary(
      request: zio.aws.codegurusecurity.model.GetMetricsSummaryRequest
  ): ZIO[
    zio.aws.codegurusecurity.CodeGuruSecurity,
    AwsError,
    zio.aws.codegurusecurity.model.GetMetricsSummaryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMetricsSummary(request))
  def untagResource(
      request: zio.aws.codegurusecurity.model.UntagResourceRequest
  ): ZIO[
    zio.aws.codegurusecurity.CodeGuruSecurity,
    AwsError,
    zio.aws.codegurusecurity.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getFindings(
      request: zio.aws.codegurusecurity.model.GetFindingsRequest
  ): ZStream[
    zio.aws.codegurusecurity.CodeGuruSecurity,
    AwsError,
    zio.aws.codegurusecurity.model.Finding.ReadOnly
  ] = ZStream.serviceWithStream(_.getFindings(request))
  def getFindingsPaginated(
      request: zio.aws.codegurusecurity.model.GetFindingsRequest
  ): ZIO[
    zio.aws.codegurusecurity.CodeGuruSecurity,
    AwsError,
    zio.aws.codegurusecurity.model.GetFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFindingsPaginated(request))
  def listTagsForResource(
      request: zio.aws.codegurusecurity.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.codegurusecurity.CodeGuruSecurity,
    AwsError,
    zio.aws.codegurusecurity.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: zio.aws.codegurusecurity.model.TagResourceRequest
  ): ZIO[
    zio.aws.codegurusecurity.CodeGuruSecurity,
    AwsError,
    zio.aws.codegurusecurity.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listScans(
      request: zio.aws.codegurusecurity.model.ListScansRequest
  ): ZStream[
    zio.aws.codegurusecurity.CodeGuruSecurity,
    AwsError,
    zio.aws.codegurusecurity.model.ScanSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listScans(request))
  def listScansPaginated(
      request: zio.aws.codegurusecurity.model.ListScansRequest
  ): ZIO[
    zio.aws.codegurusecurity.CodeGuruSecurity,
    AwsError,
    zio.aws.codegurusecurity.model.ListScansResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listScansPaginated(request))
  def listFindingsMetrics(
      request: zio.aws.codegurusecurity.model.ListFindingsMetricsRequest
  ): ZStream[zio.aws.codegurusecurity.CodeGuruSecurity, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listFindingsMetrics(request))
  def listFindingsMetricsPaginated(
      request: zio.aws.codegurusecurity.model.ListFindingsMetricsRequest
  ): ZIO[
    zio.aws.codegurusecurity.CodeGuruSecurity,
    AwsError,
    zio.aws.codegurusecurity.model.ListFindingsMetricsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFindingsMetricsPaginated(request))
  def getAccountConfiguration(
      request: zio.aws.codegurusecurity.model.GetAccountConfigurationRequest
  ): ZIO[
    zio.aws.codegurusecurity.CodeGuruSecurity,
    AwsError,
    zio.aws.codegurusecurity.model.GetAccountConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccountConfiguration(request))
}
