package zio.aws.codegurusecurity.model
import scala.jdk.CollectionConverters.*
sealed trait ScanState {
  def unwrap: software.amazon.awssdk.services.codegurusecurity.model.ScanState
}
object ScanState {
  def wrap(
      value: software.amazon.awssdk.services.codegurusecurity.model.ScanState
  ): zio.aws.codegurusecurity.model.ScanState = value match {
    case software.amazon.awssdk.services.codegurusecurity.model.ScanState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codegurusecurity.model.ScanState.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.codegurusecurity.model.ScanState.SUCCESSFUL =>
      val r = Successful
      r
    case software.amazon.awssdk.services.codegurusecurity.model.ScanState.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codegurusecurity.model.ScanState {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.ScanState =
      software.amazon.awssdk.services.codegurusecurity.model.ScanState.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.codegurusecurity.model.ScanState {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.ScanState =
      software.amazon.awssdk.services.codegurusecurity.model.ScanState.IN_PROGRESS
  }
  case object Successful extends zio.aws.codegurusecurity.model.ScanState {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.ScanState =
      software.amazon.awssdk.services.codegurusecurity.model.ScanState.SUCCESSFUL
  }
  case object Failed extends zio.aws.codegurusecurity.model.ScanState {
    override def unwrap
        : software.amazon.awssdk.services.codegurusecurity.model.ScanState =
      software.amazon.awssdk.services.codegurusecurity.model.ScanState.FAILED
  }
}
