package zio.aws.codegurusecurity
import zio.aws.codegurusecurity.model.AccountFindingsMetric.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.codegurusecurity.model.{
  ListFindingsMetricsRequest,
  GetMetricsSummaryRequest,
  GetScanRequest,
  GetAccountConfigurationRequest,
  CreateUploadUrlRequest,
  ListTagsForResourceRequest,
  UpdateAccountConfigurationRequest,
  GetFindingsRequest,
  BatchGetFindingsRequest,
  CreateScanRequest,
  UntagResourceRequest,
  ListScansRequest,
  TagResourceRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.codegurusecurity.CodeGuruSecurityAsyncClient
import zio.stream.ZStream
object CodeGuruSecurityMock extends Mock[CodeGuruSecurity] {
  object CreateUploadUrl
      extends Effect[
        CreateUploadUrlRequest,
        AwsError,
        zio.aws.codegurusecurity.model.CreateUploadUrlResponse.ReadOnly
      ]
  object UpdateAccountConfiguration
      extends Effect[
        UpdateAccountConfigurationRequest,
        AwsError,
        zio.aws.codegurusecurity.model.UpdateAccountConfigurationResponse.ReadOnly
      ]
  object BatchGetFindings
      extends Effect[
        BatchGetFindingsRequest,
        AwsError,
        zio.aws.codegurusecurity.model.BatchGetFindingsResponse.ReadOnly
      ]
  object GetScan
      extends Effect[
        GetScanRequest,
        AwsError,
        zio.aws.codegurusecurity.model.GetScanResponse.ReadOnly
      ]
  object CreateScan
      extends Effect[
        CreateScanRequest,
        AwsError,
        zio.aws.codegurusecurity.model.CreateScanResponse.ReadOnly
      ]
  object GetMetricsSummary
      extends Effect[
        GetMetricsSummaryRequest,
        AwsError,
        zio.aws.codegurusecurity.model.GetMetricsSummaryResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.codegurusecurity.model.UntagResourceResponse.ReadOnly
      ]
  object GetFindings
      extends Stream[
        GetFindingsRequest,
        AwsError,
        zio.aws.codegurusecurity.model.Finding.ReadOnly
      ]
  object GetFindingsPaginated
      extends Effect[
        GetFindingsRequest,
        AwsError,
        zio.aws.codegurusecurity.model.GetFindingsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.codegurusecurity.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.codegurusecurity.model.TagResourceResponse.ReadOnly
      ]
  object ListScans
      extends Stream[
        ListScansRequest,
        AwsError,
        zio.aws.codegurusecurity.model.ScanSummary.ReadOnly
      ]
  object ListScansPaginated
      extends Effect[
        ListScansRequest,
        AwsError,
        zio.aws.codegurusecurity.model.ListScansResponse.ReadOnly
      ]
  object ListFindingsMetrics
      extends Stream[ListFindingsMetricsRequest, AwsError, ReadOnly]
  object ListFindingsMetricsPaginated
      extends Effect[
        ListFindingsMetricsRequest,
        AwsError,
        zio.aws.codegurusecurity.model.ListFindingsMetricsResponse.ReadOnly
      ]
  object GetAccountConfiguration
      extends Effect[
        GetAccountConfigurationRequest,
        AwsError,
        zio.aws.codegurusecurity.model.GetAccountConfigurationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CodeGuruSecurity] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, CodeGuruSecurity] { rts =>
        zio.ZIO.succeed {
          new CodeGuruSecurity {
            val api: CodeGuruSecurityAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): CodeGuruSecurity = this
            def createUploadUrl(request: CreateUploadUrlRequest): IO[
              AwsError,
              zio.aws.codegurusecurity.model.CreateUploadUrlResponse.ReadOnly
            ] = proxy(CreateUploadUrl, request)
            def updateAccountConfiguration(
                request: UpdateAccountConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.codegurusecurity.model.UpdateAccountConfigurationResponse.ReadOnly
            ] = proxy(UpdateAccountConfiguration, request)
            def batchGetFindings(request: BatchGetFindingsRequest): IO[
              AwsError,
              zio.aws.codegurusecurity.model.BatchGetFindingsResponse.ReadOnly
            ] = proxy(BatchGetFindings, request)
            def getScan(request: GetScanRequest): IO[
              AwsError,
              zio.aws.codegurusecurity.model.GetScanResponse.ReadOnly
            ] = proxy(GetScan, request)
            def createScan(request: CreateScanRequest): IO[
              AwsError,
              zio.aws.codegurusecurity.model.CreateScanResponse.ReadOnly
            ] = proxy(CreateScan, request)
            def getMetricsSummary(request: GetMetricsSummaryRequest): IO[
              AwsError,
              zio.aws.codegurusecurity.model.GetMetricsSummaryResponse.ReadOnly
            ] = proxy(GetMetricsSummary, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.codegurusecurity.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def getFindings(request: GetFindingsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codegurusecurity.model.Finding.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetFindings, request)
                }
                .getOrThrowFiberFailure()
            }
            def getFindingsPaginated(request: GetFindingsRequest): IO[
              AwsError,
              zio.aws.codegurusecurity.model.GetFindingsResponse.ReadOnly
            ] = proxy(GetFindingsPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.codegurusecurity.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.codegurusecurity.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listScans(request: ListScansRequest): ZStream[
              Any,
              AwsError,
              zio.aws.codegurusecurity.model.ScanSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListScans, request)
                }
                .getOrThrowFiberFailure()
            }
            def listScansPaginated(request: ListScansRequest): IO[
              AwsError,
              zio.aws.codegurusecurity.model.ListScansResponse.ReadOnly
            ] = proxy(ListScansPaginated, request)
            def listFindingsMetrics(
                request: ListFindingsMetricsRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListFindingsMetrics, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listFindingsMetricsPaginated(
                request: ListFindingsMetricsRequest
            ): IO[
              AwsError,
              zio.aws.codegurusecurity.model.ListFindingsMetricsResponse.ReadOnly
            ] = proxy(ListFindingsMetricsPaginated, request)
            def getAccountConfiguration(
                request: GetAccountConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.codegurusecurity.model.GetAccountConfigurationResponse.ReadOnly
            ] = proxy(GetAccountConfiguration, request)
          }
        }
      }
    }
  }
}
