package zio.aws.codegurusecurity.model
import zio.aws.codegurusecurity.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Vulnerability(
    filePath: Optional[zio.aws.codegurusecurity.model.FilePath] =
      Optional.Absent,
    id: Optional[String] = Optional.Absent,
    itemCount: Optional[Integer] = Optional.Absent,
    referenceUrls: Optional[Iterable[String]] = Optional.Absent,
    relatedVulnerabilities: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codegurusecurity.model.Vulnerability = {
    import Vulnerability.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codegurusecurity.model.Vulnerability
      .builder()
      .optionallyWith(filePath.map(value => value.buildAwsValue()))(_.filePath)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(itemCount.map(value => value: java.lang.Integer))(
        _.itemCount
      )
      .optionallyWith(
        referenceUrls.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.referenceUrls)
      .optionallyWith(
        relatedVulnerabilities.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.relatedVulnerabilities)
      .build()
  }
  def asReadOnly: zio.aws.codegurusecurity.model.Vulnerability.ReadOnly =
    zio.aws.codegurusecurity.model.Vulnerability.wrap(buildAwsValue())
}
object Vulnerability {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codegurusecurity.model.Vulnerability
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codegurusecurity.model.Vulnerability =
      zio.aws.codegurusecurity.model.Vulnerability(
        filePath.map(value => value.asEditable),
        id.map(value => value),
        itemCount.map(value => value),
        referenceUrls.map(value => value),
        relatedVulnerabilities.map(value => value)
      )
    def filePath: Optional[zio.aws.codegurusecurity.model.FilePath.ReadOnly]
    def id: Optional[String]
    def itemCount: Optional[Integer]
    def referenceUrls: Optional[List[String]]
    def relatedVulnerabilities: Optional[List[String]]
    def getFilePath
        : ZIO[Any, AwsError, zio.aws.codegurusecurity.model.FilePath.ReadOnly] =
      AwsError.unwrapOptionField("filePath", filePath)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getItemCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getReferenceUrls: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("referenceUrls", referenceUrls)
    def getRelatedVulnerabilities: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("relatedVulnerabilities", relatedVulnerabilities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codegurusecurity.model.Vulnerability
  ) extends zio.aws.codegurusecurity.model.Vulnerability.ReadOnly {
    override val filePath
        : Optional[zio.aws.codegurusecurity.model.FilePath.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filePath())
        .map(value => zio.aws.codegurusecurity.model.FilePath.wrap(value))
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val itemCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.itemCount())
      .map(value => value: Integer)
    override val referenceUrls: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceUrls())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val relatedVulnerabilities: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedVulnerabilities())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codegurusecurity.model.Vulnerability
  ): zio.aws.codegurusecurity.model.Vulnerability.ReadOnly = new Wrapper(impl)
}
